/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.llm.openai;

import ai.knowly.langtorch.llm.openai.OpenAIApi;
import ai.knowly.langtorch.llm.openai.OpenAIAuthenticationInterceptor;
import ai.knowly.langtorch.llm.openai.schema.OpenAIApiExecutionException;
import ai.knowly.langtorch.llm.openai.schema.OpenAIServiceInterruptedException;
import ai.knowly.langtorch.llm.openai.schema.config.OpenAIProxyConfig;
import ai.knowly.langtorch.llm.openai.schema.config.OpenAIServiceConfig;
import ai.knowly.langtorch.llm.openai.schema.dto.OpenAIError;
import ai.knowly.langtorch.llm.openai.schema.dto.OpenAIHttpParseException;
import ai.knowly.langtorch.llm.openai.schema.dto.completion.CompletionRequest;
import ai.knowly.langtorch.llm.openai.schema.dto.completion.CompletionResult;
import ai.knowly.langtorch.llm.openai.schema.dto.completion.chat.ChatCompletionRequest;
import ai.knowly.langtorch.llm.openai.schema.dto.completion.chat.ChatCompletionResult;
import ai.knowly.langtorch.llm.openai.schema.dto.edit.EditRequest;
import ai.knowly.langtorch.llm.openai.schema.dto.edit.EditResult;
import ai.knowly.langtorch.llm.openai.schema.dto.embedding.EmbeddingRequest;
import ai.knowly.langtorch.llm.openai.schema.dto.embedding.EmbeddingResult;
import ai.knowly.langtorch.llm.openai.schema.dto.image.CreateImageEditRequest;
import ai.knowly.langtorch.llm.openai.schema.dto.image.CreateImageRequest;
import ai.knowly.langtorch.llm.openai.schema.dto.image.CreateImageVariationRequest;
import ai.knowly.langtorch.llm.openai.schema.dto.image.ImageResult;
import ai.knowly.langtorch.llm.openai.schema.dto.moderation.ModerationRequest;
import ai.knowly.langtorch.llm.openai.schema.dto.moderation.ModerationResult;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.google.common.flogger.FluentLogger;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.HttpException;
import retrofit2.Retrofit;
import retrofit2.adapter.guava.GuavaCallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class OpenAIService {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static final String BASE_URL = "https://api.openai.com/";
    private static final ObjectMapper mapper = OpenAIService.defaultObjectMapper();
    private static final String RESPONSE_FORMAT = "response_format";
    private static final MediaType MULTI_PART_FORM_DATA = MediaType.parse((String)"multipart/form-data");
    private static final String IMAGE = "image";
    private static final MediaType IMAGE_MEDIA_TYPE = MediaType.parse((String)"image");
    private final OpenAIApi api;

    @Inject
    public OpenAIService(OpenAIServiceConfig openAIServiceConfig) {
        ObjectMapper defaultObjectMapper = OpenAIService.defaultObjectMapper();
        OkHttpClient client = OpenAIService.buildClient(openAIServiceConfig);
        Retrofit retrofit = OpenAIService.defaultRetrofit(client, defaultObjectMapper);
        this.api = (OpenAIApi)retrofit.create(OpenAIApi.class);
    }

    public static <T> T execute(ListenableFuture<T> apiCall) {
        try {
            return (T)apiCall.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            ((FluentLogger.Api)((FluentLogger.Api)logger.atSevere()).withCause((Throwable)e)).log("Thread was interrupted during API call.");
            throw new OpenAIServiceInterruptedException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof HttpException) {
                HttpException httpException = (HttpException)e.getCause();
                try {
                    String errorBody = httpException.response().errorBody().string();
                    ((FluentLogger.Api)logger.atSevere()).log("HTTP Error: %s", (Object)errorBody);
                    OpenAIError error = (OpenAIError)mapper.readValue(errorBody, OpenAIError.class);
                    throw new OpenAIHttpParseException(error, e, httpException.code());
                }
                catch (IOException ioException) {
                    ((FluentLogger.Api)((FluentLogger.Api)logger.atSevere()).withCause((Throwable)ioException)).log("Error while reading errorBody");
                }
            }
            throw new OpenAIApiExecutionException(e);
        }
    }

    public static OpenAIApi buildApi(String token, Duration timeout) {
        ObjectMapper mapper = OpenAIService.defaultObjectMapper();
        OkHttpClient client = OpenAIService.buildClient(OpenAIServiceConfig.builder().setApiKey(token).setTimeoutDuration(timeout).build());
        Retrofit retrofit = OpenAIService.defaultRetrofit(client, mapper);
        return (OpenAIApi)retrofit.create(OpenAIApi.class);
    }

    public static ObjectMapper defaultObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        return mapper;
    }

    public static OkHttpClient buildClient(OpenAIServiceConfig openAIServiceConfig) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().addInterceptor((Interceptor)new OpenAIAuthenticationInterceptor(openAIServiceConfig.apiKey())).connectionPool(new ConnectionPool(5, 1L, TimeUnit.SECONDS)).readTimeout(openAIServiceConfig.timeoutDuration().toMillis(), TimeUnit.MILLISECONDS);
        openAIServiceConfig.proxyConfig().ifPresent(proxyConfig -> builder.proxy(new Proxy(OpenAIService.convertProxyEnum(proxyConfig.proxyType()), new InetSocketAddress(proxyConfig.proxyHost(), (int)proxyConfig.proxyPort()))));
        return builder.build();
    }

    public static Retrofit defaultRetrofit(OkHttpClient client, ObjectMapper mapper) {
        return new Retrofit.Builder().baseUrl(BASE_URL).client(client).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)mapper)).addCallAdapterFactory((CallAdapter.Factory)GuavaCallAdapterFactory.create()).build();
    }

    private static Proxy.Type convertProxyEnum(OpenAIProxyConfig.ProxyType proxyType) {
        if (proxyType == OpenAIProxyConfig.ProxyType.HTTP) {
            return Proxy.Type.HTTP;
        }
        if (proxyType == OpenAIProxyConfig.ProxyType.SOCKS) {
            return Proxy.Type.SOCKS;
        }
        throw new IllegalArgumentException("Unknown proxy type: " + (Object)((Object)proxyType));
    }

    @NotNull
    private static MultipartBody.Builder getMultipartBodyDefaultBuilder(CreateImageEditRequest request, RequestBody imageBody) {
        return new MultipartBody.Builder().setType(MULTI_PART_FORM_DATA).addFormDataPart("prompt", request.getPrompt()).addFormDataPart("size", request.getSize()).addFormDataPart(RESPONSE_FORMAT, request.getResponseFormat()).addFormDataPart(IMAGE, IMAGE, imageBody);
    }

    public CompletionResult createCompletion(CompletionRequest request) {
        return OpenAIService.execute(this.api.createCompletion(request));
    }

    public ListenableFuture<CompletionResult> createCompletionAsync(CompletionRequest request) {
        return this.api.createCompletion(request);
    }

    public ChatCompletionResult createChatCompletion(ChatCompletionRequest request) {
        return OpenAIService.execute(this.api.createChatCompletion(request));
    }

    public ListenableFuture<ChatCompletionResult> createChatCompletionAsync(ChatCompletionRequest request) {
        return this.api.createChatCompletion(request);
    }

    public EditResult createEdit(EditRequest request) {
        return OpenAIService.execute(this.api.createEdit(request));
    }

    public ListenableFuture<EditResult> createEditAsync(EditRequest request) {
        return this.api.createEdit(request);
    }

    public EmbeddingResult createEmbeddings(EmbeddingRequest request) {
        return OpenAIService.execute(this.api.createEmbeddings(request));
    }

    public ListenableFuture<EmbeddingResult> createEmbeddingsAsync(EmbeddingRequest request) {
        return this.api.createEmbeddings(request);
    }

    public ImageResult createImage(CreateImageRequest request) {
        return OpenAIService.execute(this.api.createImage(request));
    }

    public ListenableFuture<ImageResult> createImageAsync(CreateImageRequest request) {
        return this.api.createImage(request);
    }

    public ImageResult createImageEdit(CreateImageEditRequest request, String imagePath, String maskPath) {
        File image = new File(imagePath);
        File mask = null;
        if (maskPath != null) {
            mask = new File(maskPath);
        }
        return this.createImageEdit(request, image, mask);
    }

    public ListenableFuture<ImageResult> createImageEditAsync(CreateImageEditRequest request, String imagePath, String maskPath) {
        File image = new File(imagePath);
        File mask = null;
        if (maskPath != null) {
            mask = new File(maskPath);
        }
        return this.createImageEditAsync(request, image, mask);
    }

    public ImageResult createImageEdit(CreateImageEditRequest request, File image, File mask) {
        RequestBody imageBody = RequestBody.create((File)image, (MediaType)IMAGE_MEDIA_TYPE);
        MultipartBody.Builder builder = OpenAIService.getMultipartBodyDefaultBuilder(request, imageBody);
        if (request.getN() != null) {
            builder.addFormDataPart("n", request.getN().toString());
        }
        if (mask != null) {
            RequestBody maskBody = RequestBody.create((File)mask, (MediaType)IMAGE_MEDIA_TYPE);
            builder.addFormDataPart("mask", "mask", maskBody);
        }
        return OpenAIService.execute(this.api.createImageEdit((RequestBody)builder.build()));
    }

    public ListenableFuture<ImageResult> createImageEditAsync(CreateImageEditRequest request, File image, File mask) {
        RequestBody imageBody = RequestBody.create((File)image, (MediaType)IMAGE_MEDIA_TYPE);
        MultipartBody.Builder builder = OpenAIService.getMultipartBodyDefaultBuilder(request, imageBody);
        if (request.getN() != null) {
            builder.addFormDataPart("n", request.getN().toString());
        }
        if (mask != null) {
            RequestBody maskBody = RequestBody.create((File)mask, (MediaType)IMAGE_MEDIA_TYPE);
            builder.addFormDataPart("mask", "mask", maskBody);
        }
        return this.api.createImageEdit((RequestBody)builder.build());
    }

    public ImageResult createImageVariation(CreateImageVariationRequest request, String imagePath) {
        File image = new File(imagePath);
        return this.createImageVariation(request, image);
    }

    public ListenableFuture<ImageResult> createImageVariationAsync(CreateImageVariationRequest request, String imagePath) {
        File image = new File(imagePath);
        return this.createImageVariationAsync(request, image);
    }

    public ImageResult createImageVariation(CreateImageVariationRequest request, File image) {
        RequestBody imageBody = RequestBody.create((File)image, (MediaType)IMAGE_MEDIA_TYPE);
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MULTI_PART_FORM_DATA).addFormDataPart("size", request.getSize()).addFormDataPart(RESPONSE_FORMAT, request.getResponseFormat()).addFormDataPart(IMAGE, IMAGE, imageBody);
        if (request.getN() != null) {
            builder.addFormDataPart("n", request.getN().toString());
        }
        return OpenAIService.execute(this.api.createImageVariation((RequestBody)builder.build()));
    }

    public ListenableFuture<ImageResult> createImageVariationAsync(CreateImageVariationRequest request, File image) {
        RequestBody imageBody = RequestBody.create((File)image, (MediaType)IMAGE_MEDIA_TYPE);
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MULTI_PART_FORM_DATA).addFormDataPart("size", request.getSize()).addFormDataPart(RESPONSE_FORMAT, request.getResponseFormat()).addFormDataPart(IMAGE, IMAGE, imageBody);
        if (request.getN() != null) {
            builder.addFormDataPart("n", request.getN().toString());
        }
        return this.api.createImageVariation((RequestBody)builder.build());
    }

    public ModerationResult createModeration(ModerationRequest request) {
        return OpenAIService.execute(this.api.createModeration(request));
    }

    public ListenableFuture<ModerationResult> createModerationAsync(ModerationRequest request) {
        return this.api.createModeration(request);
    }
}

