/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.llm.openai.schema.config;

import ai.knowly.langtorch.llm.openai.schema.config.OpenAIProxyConfig;
import ai.knowly.langtorch.llm.openai.schema.config.OpenAIServiceConfig;
import java.time.Duration;
import java.util.Optional;

final class AutoValue_OpenAIServiceConfig
extends OpenAIServiceConfig {
    private final String apiKey;
    private final Duration timeoutDuration;
    private final Optional<OpenAIProxyConfig> proxyConfig;

    private AutoValue_OpenAIServiceConfig(String apiKey, Duration timeoutDuration, Optional<OpenAIProxyConfig> proxyConfig) {
        this.apiKey = apiKey;
        this.timeoutDuration = timeoutDuration;
        this.proxyConfig = proxyConfig;
    }

    @Override
    public String apiKey() {
        return this.apiKey;
    }

    @Override
    public Duration timeoutDuration() {
        return this.timeoutDuration;
    }

    @Override
    public Optional<OpenAIProxyConfig> proxyConfig() {
        return this.proxyConfig;
    }

    public String toString() {
        return "OpenAIServiceConfig{apiKey=" + this.apiKey + ", timeoutDuration=" + this.timeoutDuration + ", proxyConfig=" + this.proxyConfig + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof OpenAIServiceConfig) {
            OpenAIServiceConfig that = (OpenAIServiceConfig)o;
            return this.apiKey.equals(that.apiKey()) && this.timeoutDuration.equals(that.timeoutDuration()) && this.proxyConfig.equals(that.proxyConfig());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.apiKey.hashCode();
        h$ *= 1000003;
        h$ ^= this.timeoutDuration.hashCode();
        h$ *= 1000003;
        return h$ ^= this.proxyConfig.hashCode();
    }

    static final class Builder
    extends OpenAIServiceConfig.Builder {
        private String apiKey;
        private Duration timeoutDuration;
        private Optional<OpenAIProxyConfig> proxyConfig = Optional.empty();

        Builder() {
        }

        @Override
        public OpenAIServiceConfig.Builder setApiKey(String apiKey) {
            if (apiKey == null) {
                throw new NullPointerException("Null apiKey");
            }
            this.apiKey = apiKey;
            return this;
        }

        @Override
        public OpenAIServiceConfig.Builder setTimeoutDuration(Duration timeoutDuration) {
            if (timeoutDuration == null) {
                throw new NullPointerException("Null timeoutDuration");
            }
            this.timeoutDuration = timeoutDuration;
            return this;
        }

        @Override
        public OpenAIServiceConfig.Builder setProxyConfig(OpenAIProxyConfig proxyConfig) {
            this.proxyConfig = Optional.of(proxyConfig);
            return this;
        }

        @Override
        public OpenAIServiceConfig build() {
            if (this.apiKey == null || this.timeoutDuration == null) {
                StringBuilder missing = new StringBuilder();
                if (this.apiKey == null) {
                    missing.append(" apiKey");
                }
                if (this.timeoutDuration == null) {
                    missing.append(" timeoutDuration");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_OpenAIServiceConfig(this.apiKey, this.timeoutDuration, this.proxyConfig);
        }
    }
}

