/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.preprocessing.splitter.text.word;

import ai.knowly.langtorch.preprocessing.splitter.text.TextSplitter;
import ai.knowly.langtorch.preprocessing.splitter.text.word.WordSplitterOption;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class WordSplitter
implements TextSplitter<WordSplitterOption> {
    public static WordSplitter create() {
        return new WordSplitter();
    }

    @Override
    public List<String> splitText(WordSplitterOption option) {
        int maxLengthPerChunk = option.getMaxLengthPerChunk();
        String text = option.getText();
        ImmutableList.Builder chunks = ImmutableList.builder();
        if (maxLengthPerChunk < 1) {
            throw new IllegalArgumentException("maxLengthPerChunk should be greater than 0");
        }
        String[] words = text.split("\\s+");
        int minLengthOfWord = words[0].length();
        for (String word : words) {
            minLengthOfWord = Math.min(minLengthOfWord, word.length());
        }
        if (maxLengthPerChunk < minLengthOfWord) {
            throw new IllegalArgumentException("maxLengthPerChunk is smaller than the smallest word in the string");
        }
        StringBuilder chunk = new StringBuilder();
        int wordsLength = words.length;
        for (int i = 0; i < wordsLength; ++i) {
            String word;
            word = words[i];
            boolean isLastWord = i == wordsLength - 1;
            if (chunk.length() + word.length() + (isLastWord ? 0 : 1) <= maxLengthPerChunk) {
                chunk.append(word);
                if (isLastWord) continue;
                chunk.append(" ");
                continue;
            }
            chunks.add((Object)chunk.toString().trim());
            chunk = new StringBuilder();
            chunk.append(word).append(" ");
        }
        if (chunk.length() > 0) {
            chunks.add((Object)chunk.toString().trim());
        }
        return chunks.build();
    }
}

