/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.processor.openai.chat;

import ai.knowly.langtorch.processor.ProcessorConfig;
import ai.knowly.langtorch.processor.openai.chat.AutoValue_OpenAIChatProcessorConfig;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@AutoValue
public abstract class OpenAIChatProcessorConfig
implements ProcessorConfig {
    private static final String DEFAULT_MODEL = "gpt-3.5-turbo";
    private static final int DEFAULT_MAX_TOKEN = 2048;

    public static OpenAIChatProcessorConfig getDefaultInstance() {
        return OpenAIChatProcessorConfig.builder().build();
    }

    public static Builder builder() {
        return new AutoValue_OpenAIChatProcessorConfig.Builder().setModel(DEFAULT_MODEL).setMaxTokens(2048).setStop(new ArrayList<String>()).setLogitBias(new HashMap<String, Integer>());
    }

    public abstract Builder toBuilder();

    public abstract String getModel();

    public abstract Optional<Double> getTemperature();

    public abstract Optional<Double> getTopP();

    public abstract Optional<Integer> getN();

    public abstract Optional<Boolean> getStream();

    public abstract ImmutableList<String> getStop();

    public abstract Optional<Integer> getMaxTokens();

    public abstract Optional<Double> getPresencePenalty();

    public abstract Optional<Double> getFrequencyPenalty();

    public abstract ImmutableMap<String, Integer> getLogitBias();

    public abstract Optional<String> getUser();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setModel(String var1);

        public abstract Builder setTemperature(Double var1);

        public abstract Builder setTopP(Double var1);

        public abstract Builder setN(Integer var1);

        public abstract Builder setStream(Boolean var1);

        public abstract Builder setStop(List<String> var1);

        public abstract Builder setMaxTokens(Integer var1);

        public abstract Builder setPresencePenalty(Double var1);

        public abstract Builder setFrequencyPenalty(Double var1);

        public abstract Builder setLogitBias(Map<String, Integer> var1);

        public abstract Builder setUser(String var1);

        public abstract OpenAIChatProcessorConfig build();
    }
}

