/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.processor.openai.image;

import ai.knowly.langtorch.llm.openai.OpenAIService;
import ai.knowly.langtorch.llm.openai.schema.dto.image.CreateImageRequest;
import ai.knowly.langtorch.llm.openai.schema.dto.image.ImageResult;
import ai.knowly.langtorch.processor.Processor;
import ai.knowly.langtorch.processor.openai.image.OpenAIImageProcessorConfig;
import ai.knowly.langtorch.processor.openai.image.OpenAIImageProcessorRequestConverter;
import ai.knowly.langtorch.schema.image.Image;
import ai.knowly.langtorch.schema.image.Images;
import ai.knowly.langtorch.schema.text.SingleText;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import javax.inject.Inject;

public class OpenAIImageProcessor
implements Processor<SingleText, Images> {
    private final OpenAIService openAIService;
    private final OpenAIImageProcessorConfig openAIImageProcessorConfig;

    @Inject
    public OpenAIImageProcessor(OpenAIService openAIService, OpenAIImageProcessorConfig openAIImageProcessorConfig) {
        this.openAIService = openAIService;
        this.openAIImageProcessorConfig = openAIImageProcessorConfig;
    }

    @Override
    public Images run(SingleText inputData) {
        CreateImageRequest createImageRequest = OpenAIImageProcessorRequestConverter.convert(this.openAIImageProcessorConfig, inputData.getText());
        ImageResult result = this.openAIService.createImage(createImageRequest);
        return Images.of(result.getCreated(), (List)result.getData().stream().map(image -> Image.of(image.getUrl())).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public ListenableFuture<Images> runAsync(SingleText inputData) {
        CreateImageRequest createImageRequest = OpenAIImageProcessorRequestConverter.convert(this.openAIImageProcessorConfig, inputData.getText());
        return FluentFuture.from(this.openAIService.createImageAsync(createImageRequest)).transform(result -> Images.of(result.getCreated(), (List)result.getData().stream().map(image -> Image.of(image.getUrl())).collect(ImmutableList.toImmutableList())), MoreExecutors.directExecutor());
    }
}

