/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.processor.openai.text;

import ai.knowly.langtorch.llm.openai.OpenAIService;
import ai.knowly.langtorch.llm.openai.schema.dto.completion.CompletionRequest;
import ai.knowly.langtorch.llm.openai.schema.dto.completion.CompletionResult;
import ai.knowly.langtorch.processor.Processor;
import ai.knowly.langtorch.processor.openai.text.OpenAITextProcessorConfig;
import ai.knowly.langtorch.processor.openai.text.OpenAITextProcessorRequestConverter;
import ai.knowly.langtorch.schema.text.SingleText;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import javax.inject.Inject;

public class OpenAITextProcessor
implements Processor<SingleText, SingleText> {
    private final OpenAIService openAIService;
    private final OpenAITextProcessorConfig openAITextProcessorConfig;

    @Inject
    public OpenAITextProcessor(OpenAIService openAIService, OpenAITextProcessorConfig openAITextProcessorConfig) {
        this.openAIService = openAIService;
        this.openAITextProcessorConfig = openAITextProcessorConfig;
    }

    @Override
    public SingleText run(SingleText inputData) {
        CompletionRequest completionRequest = OpenAITextProcessorRequestConverter.convert(this.openAITextProcessorConfig, inputData.getText());
        CompletionResult completion = this.openAIService.createCompletion(completionRequest);
        return SingleText.of(completion.getChoices().get(0).getText());
    }

    @Override
    public ListenableFuture<SingleText> runAsync(SingleText inputData) {
        CompletionRequest completionRequest = OpenAITextProcessorRequestConverter.convert(this.openAITextProcessorConfig, inputData.getText());
        return FluentFuture.from(this.openAIService.createCompletionAsync(completionRequest)).transform(completion -> SingleText.of(completion.getChoices().get(0).getText()), MoreExecutors.directExecutor());
    }
}

