/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.processor.openai.text;

import ai.knowly.langtorch.processor.ProcessorConfig;
import ai.knowly.langtorch.processor.openai.text.AutoValue_OpenAITextProcessorConfig;
import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@AutoValue
public abstract class OpenAITextProcessorConfig
implements ProcessorConfig {
    @VisibleForTesting
    static final String DEFAULT_MODEL = "text-davinci-003";
    private static final int DEFAULT_MAX_TOKENS = 2048;

    public static OpenAITextProcessorConfig getDefaultInstance() {
        return OpenAITextProcessorConfig.builder().build();
    }

    public static Builder builder() {
        return new AutoValue_OpenAITextProcessorConfig.Builder().setModel(DEFAULT_MODEL).setMaxTokens(2048).setLogitBias(new HashMap<String, Integer>()).setStop(new ArrayList<String>());
    }

    abstract Builder toBuilder();

    public abstract String getModel();

    public abstract Optional<String> getSuffix();

    public abstract Optional<Integer> getMaxTokens();

    public abstract Optional<Double> getTemperature();

    public abstract Optional<Double> getTopP();

    public abstract Optional<Integer> getN();

    public abstract Optional<Boolean> getStream();

    public abstract Optional<Integer> getLogprobs();

    public abstract Optional<Boolean> getEcho();

    public abstract ImmutableList<String> getStop();

    public abstract Optional<Double> getPresencePenalty();

    public abstract Optional<Double> getFrequencyPenalty();

    public abstract Optional<Integer> getBestOf();

    public abstract ImmutableMap<String, Integer> getLogitBias();

    public abstract Optional<String> getUser();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setModel(String var1);

        public abstract Builder setSuffix(String var1);

        public abstract Builder setMaxTokens(Integer var1);

        public abstract Builder setTemperature(Double var1);

        public abstract Builder setTopP(Double var1);

        public abstract Builder setN(Integer var1);

        public abstract Builder setStream(Boolean var1);

        public abstract Builder setLogprobs(Integer var1);

        public abstract Builder setEcho(Boolean var1);

        public abstract Builder setStop(List<String> var1);

        public abstract Builder setPresencePenalty(Double var1);

        public abstract Builder setFrequencyPenalty(Double var1);

        public abstract Builder setBestOf(Integer var1);

        public abstract Builder setLogitBias(Map<String, Integer> var1);

        public abstract Builder setUser(String var1);

        public abstract OpenAITextProcessorConfig build();
    }
}

