/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.prompt.template;

import ai.knowly.langtorch.prompt.template.AutoValue_PromptTemplate;
import ai.knowly.langtorch.schema.io.Input;
import ai.knowly.langtorch.schema.io.Output;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@AutoValue
public abstract class PromptTemplate
implements Input,
Output {
    public static final String VARIABLE_TEMPLATE_PATTERN = "\\{\\{\\$([a-zA-Z0-9_]+)\\}\\}";
    private static final String DEFAULT_EXAMPLE_HEADER = "Here's examples:\n";

    public static Builder builder() {
        return new AutoValue_PromptTemplate.Builder().setExamples((List<String>)ImmutableList.of());
    }

    public static ImmutableList<String> extractVariableNames(String template) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Pattern compiledPattern = Pattern.compile(VARIABLE_TEMPLATE_PATTERN);
        Matcher matcher = compiledPattern.matcher(template);
        while (matcher.find()) {
            builder.add((Object)matcher.group(1));
        }
        return builder.build();
    }

    private static Optional<String> formatExamples(List<String> examples, Optional<String> exampleHeader) {
        if (examples.isEmpty()) {
            return Optional.empty();
        }
        StringBuilder builder = new StringBuilder();
        if (exampleHeader.isPresent()) {
            if (!exampleHeader.get().endsWith("\n")) {
                builder.append(exampleHeader.get()).append("\n");
            } else {
                builder.append(exampleHeader.get());
            }
        } else {
            builder.append(DEFAULT_EXAMPLE_HEADER);
        }
        for (String example : examples) {
            builder.append(example).append("\n");
        }
        return Optional.of(builder.toString());
    }

    public abstract Builder toBuilder();

    public abstract Optional<String> template();

    public abstract Optional<String> exampleHeader();

    public abstract ImmutableList<String> examples();

    public abstract ImmutableMap<String, String> variables();

    private void validate() {
        if (!this.template().isPresent()) {
            throw new IllegalArgumentException("Template is not present.");
        }
        ImmutableList<String> variableNamesFromTemplate = PromptTemplate.extractVariableNames(this.template().get());
        ImmutableMap<String, String> variablesInMap = this.variables();
        if (variableNamesFromTemplate.size() != variablesInMap.size()) {
            throw new IllegalArgumentException("Number of variables in the template must match the number of variables in the map.");
        }
        variableNamesFromTemplate.forEach(variableName -> {
            if (!variablesInMap.containsKey(variableName)) {
                throw new IllegalArgumentException(String.format("Variable %s is not present in the variables map.", variableName));
            }
        });
    }

    public String format() {
        this.validate();
        Optional<String> formattedExample = PromptTemplate.formatExamples(this.examples(), this.exampleHeader());
        if (this.variables().isEmpty()) {
            if (formattedExample.isPresent()) {
                return String.format("%s\n%s", this.template().get(), formattedExample.get());
            }
            return this.template().get();
        }
        Pattern compiledPattern = Pattern.compile(VARIABLE_TEMPLATE_PATTERN);
        Matcher matcher = compiledPattern.matcher(this.template().get());
        StringBuffer outputBuffer = new StringBuffer();
        while (matcher.find()) {
            String variableName = matcher.group(1);
            String replacement = (String)this.variables().getOrDefault((Object)variableName, (Object)"");
            matcher.appendReplacement(outputBuffer, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(outputBuffer);
        if (formattedExample.isPresent()) {
            return String.format("%s\n%s", outputBuffer.toString(), formattedExample.get());
        }
        return outputBuffer.toString();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setTemplate(String var1);

        public abstract Builder setExamples(List<String> var1);

        public abstract Builder setExampleHeader(String var1);

        abstract ImmutableMap.Builder<String, String> variablesBuilder();

        public Builder addVariableValuePair(String variableName, String value) {
            this.variablesBuilder().put((Object)variableName, (Object)value);
            return this;
        }

        public Builder addAllVariableValuePairs(Map<String, String> variables) {
            this.variablesBuilder().putAll(variables);
            return this;
        }

        public abstract PromptTemplate build();
    }
}

