/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.store.memory.conversation;

import ai.knowly.langtorch.schema.chat.ChatMessage;
import ai.knowly.langtorch.store.memory.MemoryContext;
import java.util.List;

public class ConversationMemoryContext
implements MemoryContext {
    private static final String DEFAULT_CONTEXT_HEADER = "Previous conversation:\n";
    private static final String DEFAULT_FORMAT_FOR_EACH_MESSAGE = "%s: %s";
    private final List<ChatMessage> chatMessages;
    private String contextHeader;
    private String formatForEachMessage;

    @Override
    public String get() {
        if (this.chatMessages.isEmpty()) {
            return "";
        }
        StringBuilder context = new StringBuilder();
        context.append(this.contextHeader).append("\n");
        this.chatMessages.forEach(chatMessage -> context.append(String.format(this.formatForEachMessage, new Object[]{chatMessage.getRole(), chatMessage.getContent()})).append("\n"));
        return context.toString();
    }

    private static String $default$contextHeader() {
        return DEFAULT_CONTEXT_HEADER;
    }

    private static String $default$formatForEachMessage() {
        return DEFAULT_FORMAT_FOR_EACH_MESSAGE;
    }

    ConversationMemoryContext(List<ChatMessage> chatMessages, String contextHeader, String formatForEachMessage) {
        this.chatMessages = chatMessages;
        this.contextHeader = contextHeader;
        this.formatForEachMessage = formatForEachMessage;
    }

    public static ConversationMemoryContextBuilder builder() {
        return new ConversationMemoryContextBuilder();
    }

    public ConversationMemoryContextBuilder toBuilder() {
        return new ConversationMemoryContextBuilder().setChatMessages(this.chatMessages).setContextHeader(this.contextHeader).setFormatForEachMessage(this.formatForEachMessage);
    }

    public List<ChatMessage> getChatMessages() {
        return this.chatMessages;
    }

    public String getContextHeader() {
        return this.contextHeader;
    }

    public String getFormatForEachMessage() {
        return this.formatForEachMessage;
    }

    public void setContextHeader(String contextHeader) {
        this.contextHeader = contextHeader;
    }

    public void setFormatForEachMessage(String formatForEachMessage) {
        this.formatForEachMessage = formatForEachMessage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConversationMemoryContext)) {
            return false;
        }
        ConversationMemoryContext other = (ConversationMemoryContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ChatMessage> this$chatMessages = this.getChatMessages();
        List<ChatMessage> other$chatMessages = other.getChatMessages();
        if (this$chatMessages == null ? other$chatMessages != null : !((Object)this$chatMessages).equals(other$chatMessages)) {
            return false;
        }
        String this$contextHeader = this.getContextHeader();
        String other$contextHeader = other.getContextHeader();
        if (this$contextHeader == null ? other$contextHeader != null : !this$contextHeader.equals(other$contextHeader)) {
            return false;
        }
        String this$formatForEachMessage = this.getFormatForEachMessage();
        String other$formatForEachMessage = other.getFormatForEachMessage();
        return !(this$formatForEachMessage == null ? other$formatForEachMessage != null : !this$formatForEachMessage.equals(other$formatForEachMessage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConversationMemoryContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ChatMessage> $chatMessages = this.getChatMessages();
        result = result * 59 + ($chatMessages == null ? 43 : ((Object)$chatMessages).hashCode());
        String $contextHeader = this.getContextHeader();
        result = result * 59 + ($contextHeader == null ? 43 : $contextHeader.hashCode());
        String $formatForEachMessage = this.getFormatForEachMessage();
        result = result * 59 + ($formatForEachMessage == null ? 43 : $formatForEachMessage.hashCode());
        return result;
    }

    public String toString() {
        return "ConversationMemoryContext(chatMessages=" + this.getChatMessages() + ", contextHeader=" + this.getContextHeader() + ", formatForEachMessage=" + this.getFormatForEachMessage() + ")";
    }

    public static class ConversationMemoryContextBuilder {
        private List<ChatMessage> chatMessages;
        private boolean contextHeader$set;
        private String contextHeader$value;
        private boolean formatForEachMessage$set;
        private String formatForEachMessage$value;

        ConversationMemoryContextBuilder() {
        }

        public ConversationMemoryContextBuilder setChatMessages(List<ChatMessage> chatMessages) {
            this.chatMessages = chatMessages;
            return this;
        }

        public ConversationMemoryContextBuilder setContextHeader(String contextHeader) {
            this.contextHeader$value = contextHeader;
            this.contextHeader$set = true;
            return this;
        }

        public ConversationMemoryContextBuilder setFormatForEachMessage(String formatForEachMessage) {
            this.formatForEachMessage$value = formatForEachMessage;
            this.formatForEachMessage$set = true;
            return this;
        }

        public ConversationMemoryContext build() {
            String contextHeader$value = this.contextHeader$value;
            if (!this.contextHeader$set) {
                contextHeader$value = ConversationMemoryContext.$default$contextHeader();
            }
            String formatForEachMessage$value = this.formatForEachMessage$value;
            if (!this.formatForEachMessage$set) {
                formatForEachMessage$value = ConversationMemoryContext.$default$formatForEachMessage();
            }
            return new ConversationMemoryContext(this.chatMessages, contextHeader$value, formatForEachMessage$value);
        }

        public String toString() {
            return "ConversationMemoryContext.ConversationMemoryContextBuilder(chatMessages=" + this.chatMessages + ", contextHeader$value=" + this.contextHeader$value + ", formatForEachMessage$value=" + this.formatForEachMessage$value + ")";
        }
    }
}

