/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.tool;

import ai.knowly.langtorch.tool.AutoValue_Tool;
import ai.knowly.langtorch.tool.Function;
import com.google.auto.value.AutoValue;
import java.util.HashMap;
import java.util.Map;

@AutoValue
public abstract class Tool {
    public static Builder builder() {
        return new AutoValue_Tool.Builder().setFunctionRegistry(new HashMap<String, Function>());
    }

    public abstract String name();

    public abstract String description();

    public abstract Map<String, Function> functionRegistry();

    public Object invoke(String label, Object ... args) {
        if (this.functionRegistry().isEmpty()) {
            throw new IllegalArgumentException("Function registry not found");
        }
        if (this.functionRegistry().containsKey(label)) {
            return this.functionRegistry().get(label).execute(args);
        }
        throw new IllegalArgumentException("Function not found");
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setName(String var1);

        public abstract Builder setDescription(String var1);

        public abstract Builder setFunctionRegistry(Map<String, Function> var1);

        abstract Map<String, Function> functionRegistry();

        public Builder register(String label, Function function) {
            this.functionRegistry().put(label, function);
            return this;
        }

        public abstract Tool build();
    }
}

