/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.utils.api.endpoint;

import ai.knowly.langtorch.utils.Environment;
import ai.knowly.langtorch.utils.api.endpoint.EndpointUtil;
import ai.knowly.langtorch.utils.api.endpoint.VectorStoreApiEndpoint;
import com.google.common.flogger.FluentLogger;
import java.util.Optional;

public class PineconeEnvUtil {
    private PineconeEnvUtil() {
    }

    public static String getEndPoint(Environment environment) {
        return PineconeEnvUtil.getPineconeEndPointFromEnv(Optional.empty(), environment);
    }

    public static String getEndPoint(FluentLogger logger, Environment environment) {
        return PineconeEnvUtil.getPineconeEndPointFromEnv(Optional.ofNullable(logger), environment);
    }

    private static String getPineconeEndPointFromEnv(Optional<FluentLogger> logger, Environment environment) {
        String endpointFromEnv = EndpointUtil.getEndPoint(VectorStoreApiEndpoint.PINECONE_ENDPOINT, environment);
        logger.ifPresent(l -> EndpointUtil.logEndPoint(l, VectorStoreApiEndpoint.PINECONE_ENDPOINT.name(), endpointFromEnv));
        return endpointFromEnv;
    }
}

