/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.utils.api.key;

import ai.knowly.langtorch.utils.Environment;
import ai.knowly.langtorch.utils.api.key.KeyNotFoundException;
import ai.knowly.langtorch.utils.api.key.KeyType;
import com.google.common.flogger.FluentLogger;
import io.github.cdimascio.dotenv.Dotenv;

public class ApiKeyEnvUtils {
    private ApiKeyEnvUtils() {
    }

    static void logPartialApiKey(FluentLogger logger, String provider, String apiKey) {
        ((FluentLogger.Api)logger.atInfo()).log("Using %s API key: ***************" + apiKey.substring(apiKey.length() - 6), (Object)provider);
    }

    static String getKeyFromEnv(KeyType keyType, Environment environment) {
        Dotenv dotenv = environment == Environment.PRODUCTION ? Dotenv.configure().ignoreIfMissing().load() : Dotenv.configure().directory("src/test/resources").ignoreIfMissing().load();
        String key = dotenv.get(keyType.name());
        if (key == null) {
            throw new KeyNotFoundException(String.format("Could not find %s in .env file. Please add it to the .env file.", keyType.name()));
        }
        return key;
    }
}

