/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.utils.api.key;

import ai.knowly.langtorch.utils.Environment;
import ai.knowly.langtorch.utils.api.key.ApiKeyEnvUtils;
import ai.knowly.langtorch.utils.api.key.KeyType;
import com.google.common.flogger.FluentLogger;
import java.util.Optional;

public class PineconeKeyUtil {
    private PineconeKeyUtil() {
    }

    public static String getKey(FluentLogger logger, Environment environment) {
        return PineconeKeyUtil.getKey(Optional.ofNullable(logger), environment);
    }

    public static String getKey(Environment environment) {
        return PineconeKeyUtil.getKey(Optional.empty(), environment);
    }

    private static String getKey(Optional<FluentLogger> logger, Environment environment) {
        String keyFromEnv = ApiKeyEnvUtils.getKeyFromEnv(KeyType.PINECONE_API_KEY, environment);
        logger.ifPresent(l -> ApiKeyEnvUtils.logPartialApiKey(l, KeyType.PINECONE_API_KEY.name(), keyFromEnv));
        return keyFromEnv;
    }
}

