/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.utils.graph;

import ai.knowly.langtorch.utils.graph.DAGViolationException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;

public class TopologicalSorter {
    public static List<String> topologicalSort(Map<String, List<String>> graph) {
        Queue<String> queue;
        Deque<String> stack;
        Map<String, Integer> inDegree = TopologicalSorter.initializeInDegree(graph);
        if (!TopologicalSorter.isTopologicalSortPossible(inDegree, stack = TopologicalSorter.processNodes(graph, inDegree, queue = TopologicalSorter.getZeroInDegreeNodes(inDegree)))) {
            throw new DAGViolationException("The graph has at least one cycle, so a topological sort is not possible.");
        }
        return TopologicalSorter.getResultFromStack(stack);
    }

    private static Map<String, Integer> initializeInDegree(Map<String, List<String>> graph) {
        HashMap<String, Integer> inDegree = new HashMap<String, Integer>();
        graph.entrySet().forEach(entry -> {
            inDegree.putIfAbsent((String)entry.getKey(), 0);
            for (String neighbor : (List)entry.getValue()) {
                inDegree.put(neighbor, inDegree.getOrDefault(neighbor, 0) + 1);
            }
        });
        return inDegree;
    }

    private static Queue<String> getZeroInDegreeNodes(Map<String, Integer> inDegree) {
        LinkedList<String> queue = new LinkedList<String>();
        for (Map.Entry<String, Integer> entry : inDegree.entrySet()) {
            if (entry.getValue() != 0) continue;
            queue.add(entry.getKey());
        }
        return queue;
    }

    private static Deque<String> processNodes(Map<String, List<String>> graph, Map<String, Integer> inDegree, Queue<String> queue) {
        ArrayDeque<String> stack = new ArrayDeque<String>();
        while (!queue.isEmpty()) {
            String node = queue.poll();
            stack.push(node);
            if (!graph.containsKey(node)) continue;
            for (String neighbor : graph.get(node)) {
                inDegree.put(neighbor, inDegree.get(neighbor) - 1);
                if (inDegree.get(neighbor) != 0) continue;
                queue.add(neighbor);
            }
        }
        return stack;
    }

    private static boolean isTopologicalSortPossible(Map<String, Integer> inDegree, Deque<String> stack) {
        return stack.size() == inDegree.size();
    }

    private static List<String> getResultFromStack(Deque<String> stack) {
        ArrayList<String> result = new ArrayList<String>();
        while (!stack.isEmpty()) {
            result.add(stack.pop());
        }
        return result;
    }

    private TopologicalSorter() {
    }
}

