/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.connector.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class Record {
    Map<String, Object> columns;

    public Optional<Object> getColumn(String columnName) {
        if (!this.columns.containsKey(columnName)) {
            return Optional.empty();
        }
        return Optional.of(this.columns.get(columnName));
    }

    public static RecordBuilder builder() {
        return new RecordBuilder();
    }

    public RecordBuilder toBuilder() {
        RecordBuilder builder = new RecordBuilder();
        if (this.columns != null) {
            builder.setColumns(this.columns);
        }
        return builder;
    }

    public Map<String, Object> getColumns() {
        return this.columns;
    }

    public void setColumns(Map<String, Object> columns) {
        this.columns = columns;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Record)) {
            return false;
        }
        Record other = (Record)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Object> this$columns = this.getColumns();
        Map<String, Object> other$columns = other.getColumns();
        return !(this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Record;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Object> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        return result;
    }

    public String toString() {
        return "Record(columns=" + this.getColumns() + ")";
    }

    private Record(Map<String, Object> columns) {
        this.columns = columns;
    }

    public static class RecordBuilder {
        private ArrayList<String> columns$key;
        private ArrayList<Object> columns$value;

        RecordBuilder() {
        }

        public RecordBuilder setColumn(String columnKey, Object columnValue) {
            if (this.columns$key == null) {
                this.columns$key = new ArrayList();
                this.columns$value = new ArrayList();
            }
            this.columns$key.add(columnKey);
            this.columns$value.add(columnValue);
            return this;
        }

        public RecordBuilder setColumns(Map<? extends String, ? extends Object> columns) {
            if (columns == null) {
                throw new NullPointerException("columns cannot be null");
            }
            if (this.columns$key == null) {
                this.columns$key = new ArrayList();
                this.columns$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : columns.entrySet()) {
                this.columns$key.add($lombokEntry.getKey());
                this.columns$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public RecordBuilder clearColumns() {
            if (this.columns$key != null) {
                this.columns$key.clear();
                this.columns$value.clear();
            }
            return this;
        }

        public Record build() {
            Map<Object, Object> columns;
            switch (this.columns$key == null ? 0 : this.columns$key.size()) {
                case 0: {
                    columns = Collections.emptyMap();
                    break;
                }
                case 1: {
                    columns = Collections.singletonMap(this.columns$key.get(0), this.columns$value.get(0));
                    break;
                }
                default: {
                    columns = new LinkedHashMap(this.columns$key.size() < 0x40000000 ? 1 + this.columns$key.size() + (this.columns$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.columns$key.size(); ++$i) {
                        columns.put(this.columns$key.get($i), this.columns$value.get($i));
                    }
                    columns = Collections.unmodifiableMap(columns);
                }
            }
            return new Record(columns);
        }

        public String toString() {
            return "Record.RecordBuilder(columns$key=" + this.columns$key + ", columns$value=" + this.columns$value + ")";
        }
    }
}

