/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.connector.sql;

import ai.knowly.langtorch.connector.ConnectorOption;
import ai.knowly.langtorch.connector.sql.ConnectionDetail;
import java.sql.Connection;
import java.util.Optional;
import lombok.NonNull;

public class SQLConnectorOption
implements ConnectorOption {
    @NonNull
    private String query;
    private Connection connection;
    private ConnectionDetail connectionDetail;

    public Optional<Connection> getConnection() {
        return Optional.ofNullable(this.connection);
    }

    public Optional<ConnectionDetail> getConnectionDetail() {
        return Optional.ofNullable(this.connectionDetail);
    }

    public static SQLConnectorOptionBuilder builder() {
        return new SQLConnectorOptionBuilder();
    }

    public SQLConnectorOptionBuilder toBuilder() {
        return new SQLConnectorOptionBuilder().setQuery(this.query).setConnection(this.connection).setConnectionDetail(this.connectionDetail);
    }

    @NonNull
    public String getQuery() {
        return this.query;
    }

    public void setQuery(@NonNull String query) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        this.query = query;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void setConnectionDetail(ConnectionDetail connectionDetail) {
        this.connectionDetail = connectionDetail;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SQLConnectorOption)) {
            return false;
        }
        SQLConnectorOption other = (SQLConnectorOption)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        Optional<Connection> this$connection = this.getConnection();
        Optional<Connection> other$connection = other.getConnection();
        if (this$connection == null ? other$connection != null : !((Object)this$connection).equals(other$connection)) {
            return false;
        }
        Optional<ConnectionDetail> this$connectionDetail = this.getConnectionDetail();
        Optional<ConnectionDetail> other$connectionDetail = other.getConnectionDetail();
        return !(this$connectionDetail == null ? other$connectionDetail != null : !((Object)this$connectionDetail).equals(other$connectionDetail));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SQLConnectorOption;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        Optional<Connection> $connection = this.getConnection();
        result = result * 59 + ($connection == null ? 43 : ((Object)$connection).hashCode());
        Optional<ConnectionDetail> $connectionDetail = this.getConnectionDetail();
        result = result * 59 + ($connectionDetail == null ? 43 : ((Object)$connectionDetail).hashCode());
        return result;
    }

    public String toString() {
        return "SQLConnectorOption(query=" + this.getQuery() + ", connection=" + this.getConnection() + ", connectionDetail=" + this.getConnectionDetail() + ")";
    }

    private SQLConnectorOption(@NonNull String query, Connection connection, ConnectionDetail connectionDetail) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        this.query = query;
        this.connection = connection;
        this.connectionDetail = connectionDetail;
    }

    public static class SQLConnectorOptionBuilder {
        private String query;
        private Connection connection;
        private ConnectionDetail connectionDetail;

        SQLConnectorOptionBuilder() {
        }

        public SQLConnectorOptionBuilder setQuery(@NonNull String query) {
            if (query == null) {
                throw new NullPointerException("query is marked non-null but is null");
            }
            this.query = query;
            return this;
        }

        public SQLConnectorOptionBuilder setConnection(Connection connection) {
            this.connection = connection;
            return this;
        }

        public SQLConnectorOptionBuilder setConnectionDetail(ConnectionDetail connectionDetail) {
            this.connectionDetail = connectionDetail;
            return this;
        }

        public SQLConnectorOption build() {
            return new SQLConnectorOption(this.query, this.connection, this.connectionDetail);
        }

        public String toString() {
            return "SQLConnectorOption.SQLConnectorOptionBuilder(query=" + this.query + ", connection=" + this.connection + ", connectionDetail=" + this.connectionDetail + ")";
        }
    }
}

