/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.hub;

import ai.knowly.langtorch.hub.module.token.OpenAITokenModule;
import ai.knowly.langtorch.hub.module.token.TokenUsage;
import ai.knowly.langtorch.hub.schema.LangtorchHubConfig;
import ai.knowly.langtorch.hub.schema.OpenAIKeyConfig;
import ai.knowly.langtorch.llm.openai.modules.key.OpenAIServiceConfigWithExplicitAPIKeyModule;
import ai.knowly.langtorch.llm.openai.modules.key.OpenAIServiceConfigWithImplicitAPIKeyModule;
import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;

public class LangtorchHub {
    private final Injector injector;

    public LangtorchHub(LangtorchHubConfig config, ImmutableList<AbstractModule> extraModules) {
        ImmutableList.Builder moduleBuilder = ImmutableList.builder();
        moduleBuilder.add((Object)new OpenAITokenModule());
        moduleBuilder.addAll(extraModules);
        config.getOpenAIKeyConfig().ifPresent(openAIKeyConfig -> moduleBuilder.add((Object)this.getOpenAIModule((OpenAIKeyConfig)openAIKeyConfig)));
        this.injector = Guice.createInjector((Iterable)moduleBuilder.build());
    }

    private AbstractModule getOpenAIModule(OpenAIKeyConfig openAIKeyConfig) {
        if (openAIKeyConfig.isReadFromEnvFile()) {
            return new OpenAIServiceConfigWithImplicitAPIKeyModule();
        }
        if (!openAIKeyConfig.getOpenAiApiKey().isPresent()) {
            throw new IllegalArgumentException("OpenAI API key is not present. Please provide the API key in the config.");
        }
        return new OpenAIServiceConfigWithExplicitAPIKeyModule(openAIKeyConfig.getOpenAiApiKey().get());
    }

    public <T> T getInstance(Class<T> clazz) {
        return (T)this.injector.getInstance(clazz);
    }

    public TokenUsage getTokenUsage() {
        return (TokenUsage)this.injector.getInstance(TokenUsage.class);
    }
}

