/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.hub.schema;

import java.util.Optional;

public class OpenAIKeyConfig {
    private String openAiApiKey;
    private boolean readFromEnvFile;

    public Optional<String> getOpenAiApiKey() {
        return Optional.ofNullable(this.openAiApiKey);
    }

    public static OpenAIKeyConfigBuilder builder() {
        return new OpenAIKeyConfigBuilder();
    }

    public OpenAIKeyConfigBuilder toBuilder() {
        return new OpenAIKeyConfigBuilder().setOpenAiApiKey(this.openAiApiKey).setReadFromEnvFile(this.readFromEnvFile);
    }

    public boolean isReadFromEnvFile() {
        return this.readFromEnvFile;
    }

    public void setOpenAiApiKey(String openAiApiKey) {
        this.openAiApiKey = openAiApiKey;
    }

    public void setReadFromEnvFile(boolean readFromEnvFile) {
        this.readFromEnvFile = readFromEnvFile;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenAIKeyConfig)) {
            return false;
        }
        OpenAIKeyConfig other = (OpenAIKeyConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isReadFromEnvFile() != other.isReadFromEnvFile()) {
            return false;
        }
        Optional<String> this$openAiApiKey = this.getOpenAiApiKey();
        Optional<String> other$openAiApiKey = other.getOpenAiApiKey();
        return !(this$openAiApiKey == null ? other$openAiApiKey != null : !((Object)this$openAiApiKey).equals(other$openAiApiKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OpenAIKeyConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isReadFromEnvFile() ? 79 : 97);
        Optional<String> $openAiApiKey = this.getOpenAiApiKey();
        result = result * 59 + ($openAiApiKey == null ? 43 : ((Object)$openAiApiKey).hashCode());
        return result;
    }

    public String toString() {
        return "OpenAIKeyConfig(openAiApiKey=" + this.getOpenAiApiKey() + ", readFromEnvFile=" + this.isReadFromEnvFile() + ")";
    }

    private OpenAIKeyConfig(String openAiApiKey, boolean readFromEnvFile) {
        this.openAiApiKey = openAiApiKey;
        this.readFromEnvFile = readFromEnvFile;
    }

    public static class OpenAIKeyConfigBuilder {
        private String openAiApiKey;
        private boolean readFromEnvFile;

        OpenAIKeyConfigBuilder() {
        }

        public OpenAIKeyConfigBuilder setOpenAiApiKey(String openAiApiKey) {
            this.openAiApiKey = openAiApiKey;
            return this;
        }

        public OpenAIKeyConfigBuilder setReadFromEnvFile(boolean readFromEnvFile) {
            this.readFromEnvFile = readFromEnvFile;
            return this;
        }

        public OpenAIKeyConfig build() {
            return new OpenAIKeyConfig(this.openAiApiKey, this.readFromEnvFile);
        }

        public String toString() {
            return "OpenAIKeyConfig.OpenAIKeyConfigBuilder(openAiApiKey=" + this.openAiApiKey + ", readFromEnvFile=" + this.readFromEnvFile + ")";
        }
    }
}

