/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.llm.cohere;

import ai.knowly.langtorch.llm.cohere.CohereAIApi;
import ai.knowly.langtorch.llm.cohere.CohereAuthenticationInterceptor;
import ai.knowly.langtorch.llm.cohere.schema.CohereExecutionException;
import ai.knowly.langtorch.llm.cohere.schema.CohereGenerateRequest;
import ai.knowly.langtorch.llm.cohere.schema.CohereGenerateResponse;
import ai.knowly.langtorch.llm.cohere.schema.CohereHttpException;
import ai.knowly.langtorch.llm.cohere.schema.CohereInterruptedException;
import ai.knowly.langtorch.llm.cohere.schema.config.CohereAIServiceConfig;
import ai.knowly.langtorch.llm.cohere.serialization.CohereGenerateRequestAdapter;
import ai.knowly.langtorch.utils.future.retry.FutureRetrier;
import com.google.common.flogger.FluentLogger;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.inject.Inject;
import java.io.IOException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.HttpException;
import retrofit2.Retrofit;
import retrofit2.adapter.guava.GuavaCallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

public class CohereAIService {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static final String BASE_URL = "https://api.cohere.ai/";
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(CohereGenerateRequest.class, (Object)new CohereGenerateRequestAdapter()).create();
    private final CohereAIApi api;
    private final FutureRetrier futureRetrier;
    private final ScheduledExecutorService scheduledExecutor;

    @Inject
    public CohereAIService(CohereAIServiceConfig config) {
        this.api = CohereAIService.buildApi(config);
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
        this.futureRetrier = new FutureRetrier(this.scheduledExecutor, config.backoffStrategy(), config.retryConfig());
    }

    public static <T> T execute(ListenableFuture<T> apiCall) {
        try {
            return (T)apiCall.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            ((FluentLogger.Api)((FluentLogger.Api)logger.atSevere()).withCause((Throwable)e)).log("Thread was interrupted during API call.");
            throw new CohereInterruptedException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof HttpException) {
                HttpException httpException = (HttpException)e.getCause();
                try {
                    String errorBody = httpException.response().errorBody().string();
                    ((FluentLogger.Api)logger.atSevere()).log("HTTP Error: %s", (Object)errorBody);
                    throw new CohereHttpException(errorBody, (Exception)httpException);
                }
                catch (IOException ioException) {
                    ((FluentLogger.Api)((FluentLogger.Api)logger.atSevere()).withCause((Throwable)ioException)).log("Error while reading errorBody");
                }
            }
            throw new CohereExecutionException(e);
        }
    }

    public static CohereAIApi buildApi(CohereAIServiceConfig config) {
        Objects.requireNonNull(config.apiKey(), "Cohere token required");
        OkHttpClient client = CohereAIService.defaultClient(config.apiKey(), config.timeoutDuration());
        Retrofit retrofit = CohereAIService.defaultRetrofit(client, gson);
        return (CohereAIApi)retrofit.create(CohereAIApi.class);
    }

    public static OkHttpClient defaultClient(String token, Duration timeout) {
        return new OkHttpClient.Builder().addInterceptor((Interceptor)new CohereAuthenticationInterceptor(token)).connectionPool(new ConnectionPool(5, 1L, TimeUnit.SECONDS)).readTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS).build();
    }

    public static Retrofit defaultRetrofit(OkHttpClient client, Gson gson) {
        return new Retrofit.Builder().baseUrl(BASE_URL).client(client).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).addCallAdapterFactory((CallAdapter.Factory)GuavaCallAdapterFactory.create()).build();
    }

    public CohereGenerateResponse generate(CohereGenerateRequest request) {
        return (CohereGenerateResponse)CohereAIService.execute(this.futureRetrier.runWithRetries(() -> this.api.generate(request), response -> true));
    }

    public ListenableFuture<CohereGenerateResponse> generateAsync(CohereGenerateRequest request) {
        return this.futureRetrier.runWithRetries(() -> this.api.generate(request), response -> true);
    }
}

