/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.llm.minimax.schema.dto.completion;

import ai.knowly.langtorch.schema.io.Input;
import ai.knowly.langtorch.schema.io.Output;
import ai.knowly.langtorch.store.memory.MemoryValue;
import java.util.List;

public class ChatCompletionRequest {
    private String model;
    private Boolean withEmotion;
    private Boolean stream;
    private Boolean useStandardSse;
    private Integer beamWidth;
    private String prompt;
    private RoleMeta roleMeta;
    private List<Message> messages;
    private Boolean continueLastMessage;
    private Long tokensToGenerate;
    private Float temperature;
    private Float topP;
    private Boolean skipInfoMask;

    private static Boolean $default$withEmotion() {
        return false;
    }

    private static Boolean $default$stream() {
        return false;
    }

    private static Boolean $default$useStandardSse() {
        return false;
    }

    private static Integer $default$beamWidth() {
        return 1;
    }

    private static Boolean $default$continueLastMessage() {
        return false;
    }

    private static Long $default$tokensToGenerate() {
        return 128L;
    }

    private static Float $default$temperature() {
        return Float.valueOf(0.9f);
    }

    private static Float $default$topP() {
        return Float.valueOf(0.95f);
    }

    private static Boolean $default$skipInfoMask() {
        return false;
    }

    ChatCompletionRequest(String model, Boolean withEmotion, Boolean stream, Boolean useStandardSse, Integer beamWidth, String prompt, RoleMeta roleMeta, List<Message> messages, Boolean continueLastMessage, Long tokensToGenerate, Float temperature, Float topP, Boolean skipInfoMask) {
        this.model = model;
        this.withEmotion = withEmotion;
        this.stream = stream;
        this.useStandardSse = useStandardSse;
        this.beamWidth = beamWidth;
        this.prompt = prompt;
        this.roleMeta = roleMeta;
        this.messages = messages;
        this.continueLastMessage = continueLastMessage;
        this.tokensToGenerate = tokensToGenerate;
        this.temperature = temperature;
        this.topP = topP;
        this.skipInfoMask = skipInfoMask;
    }

    public static ChatCompletionRequestBuilder builder() {
        return new ChatCompletionRequestBuilder();
    }

    public ChatCompletionRequestBuilder toBuilder() {
        return new ChatCompletionRequestBuilder().setModel(this.model).setWithEmotion(this.withEmotion).setStream(this.stream).setUseStandardSse(this.useStandardSse).setBeamWidth(this.beamWidth).setPrompt(this.prompt).setRoleMeta(this.roleMeta).setMessages(this.messages).setContinueLastMessage(this.continueLastMessage).setTokensToGenerate(this.tokensToGenerate).setTemperature(this.temperature).setTopP(this.topP).setSkipInfoMask(this.skipInfoMask);
    }

    public String getModel() {
        return this.model;
    }

    public Boolean getWithEmotion() {
        return this.withEmotion;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public Boolean getUseStandardSse() {
        return this.useStandardSse;
    }

    public Integer getBeamWidth() {
        return this.beamWidth;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public RoleMeta getRoleMeta() {
        return this.roleMeta;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public Boolean getContinueLastMessage() {
        return this.continueLastMessage;
    }

    public Long getTokensToGenerate() {
        return this.tokensToGenerate;
    }

    public Float getTemperature() {
        return this.temperature;
    }

    public Float getTopP() {
        return this.topP;
    }

    public Boolean getSkipInfoMask() {
        return this.skipInfoMask;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setWithEmotion(Boolean withEmotion) {
        this.withEmotion = withEmotion;
    }

    public void setStream(Boolean stream) {
        this.stream = stream;
    }

    public void setUseStandardSse(Boolean useStandardSse) {
        this.useStandardSse = useStandardSse;
    }

    public void setBeamWidth(Integer beamWidth) {
        this.beamWidth = beamWidth;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public void setRoleMeta(RoleMeta roleMeta) {
        this.roleMeta = roleMeta;
    }

    public void setMessages(List<Message> messages) {
        this.messages = messages;
    }

    public void setContinueLastMessage(Boolean continueLastMessage) {
        this.continueLastMessage = continueLastMessage;
    }

    public void setTokensToGenerate(Long tokensToGenerate) {
        this.tokensToGenerate = tokensToGenerate;
    }

    public void setTemperature(Float temperature) {
        this.temperature = temperature;
    }

    public void setTopP(Float topP) {
        this.topP = topP;
    }

    public void setSkipInfoMask(Boolean skipInfoMask) {
        this.skipInfoMask = skipInfoMask;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatCompletionRequest)) {
            return false;
        }
        ChatCompletionRequest other = (ChatCompletionRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$withEmotion = this.getWithEmotion();
        Boolean other$withEmotion = other.getWithEmotion();
        if (this$withEmotion == null ? other$withEmotion != null : !((Object)this$withEmotion).equals(other$withEmotion)) {
            return false;
        }
        Boolean this$stream = this.getStream();
        Boolean other$stream = other.getStream();
        if (this$stream == null ? other$stream != null : !((Object)this$stream).equals(other$stream)) {
            return false;
        }
        Boolean this$useStandardSse = this.getUseStandardSse();
        Boolean other$useStandardSse = other.getUseStandardSse();
        if (this$useStandardSse == null ? other$useStandardSse != null : !((Object)this$useStandardSse).equals(other$useStandardSse)) {
            return false;
        }
        Integer this$beamWidth = this.getBeamWidth();
        Integer other$beamWidth = other.getBeamWidth();
        if (this$beamWidth == null ? other$beamWidth != null : !((Object)this$beamWidth).equals(other$beamWidth)) {
            return false;
        }
        Boolean this$continueLastMessage = this.getContinueLastMessage();
        Boolean other$continueLastMessage = other.getContinueLastMessage();
        if (this$continueLastMessage == null ? other$continueLastMessage != null : !((Object)this$continueLastMessage).equals(other$continueLastMessage)) {
            return false;
        }
        Long this$tokensToGenerate = this.getTokensToGenerate();
        Long other$tokensToGenerate = other.getTokensToGenerate();
        if (this$tokensToGenerate == null ? other$tokensToGenerate != null : !((Object)this$tokensToGenerate).equals(other$tokensToGenerate)) {
            return false;
        }
        Float this$temperature = this.getTemperature();
        Float other$temperature = other.getTemperature();
        if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
            return false;
        }
        Float this$topP = this.getTopP();
        Float other$topP = other.getTopP();
        if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
            return false;
        }
        Boolean this$skipInfoMask = this.getSkipInfoMask();
        Boolean other$skipInfoMask = other.getSkipInfoMask();
        if (this$skipInfoMask == null ? other$skipInfoMask != null : !((Object)this$skipInfoMask).equals(other$skipInfoMask)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$prompt = this.getPrompt();
        String other$prompt = other.getPrompt();
        if (this$prompt == null ? other$prompt != null : !this$prompt.equals(other$prompt)) {
            return false;
        }
        RoleMeta this$roleMeta = this.getRoleMeta();
        RoleMeta other$roleMeta = other.getRoleMeta();
        if (this$roleMeta == null ? other$roleMeta != null : !((Object)this$roleMeta).equals(other$roleMeta)) {
            return false;
        }
        List<Message> this$messages = this.getMessages();
        List<Message> other$messages = other.getMessages();
        return !(this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatCompletionRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $withEmotion = this.getWithEmotion();
        result = result * 59 + ($withEmotion == null ? 43 : ((Object)$withEmotion).hashCode());
        Boolean $stream = this.getStream();
        result = result * 59 + ($stream == null ? 43 : ((Object)$stream).hashCode());
        Boolean $useStandardSse = this.getUseStandardSse();
        result = result * 59 + ($useStandardSse == null ? 43 : ((Object)$useStandardSse).hashCode());
        Integer $beamWidth = this.getBeamWidth();
        result = result * 59 + ($beamWidth == null ? 43 : ((Object)$beamWidth).hashCode());
        Boolean $continueLastMessage = this.getContinueLastMessage();
        result = result * 59 + ($continueLastMessage == null ? 43 : ((Object)$continueLastMessage).hashCode());
        Long $tokensToGenerate = this.getTokensToGenerate();
        result = result * 59 + ($tokensToGenerate == null ? 43 : ((Object)$tokensToGenerate).hashCode());
        Float $temperature = this.getTemperature();
        result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
        Float $topP = this.getTopP();
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        Boolean $skipInfoMask = this.getSkipInfoMask();
        result = result * 59 + ($skipInfoMask == null ? 43 : ((Object)$skipInfoMask).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $prompt = this.getPrompt();
        result = result * 59 + ($prompt == null ? 43 : $prompt.hashCode());
        RoleMeta $roleMeta = this.getRoleMeta();
        result = result * 59 + ($roleMeta == null ? 43 : ((Object)$roleMeta).hashCode());
        List<Message> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        return result;
    }

    public String toString() {
        return "ChatCompletionRequest(model=" + this.getModel() + ", withEmotion=" + this.getWithEmotion() + ", stream=" + this.getStream() + ", useStandardSse=" + this.getUseStandardSse() + ", beamWidth=" + this.getBeamWidth() + ", prompt=" + this.getPrompt() + ", roleMeta=" + this.getRoleMeta() + ", messages=" + this.getMessages() + ", continueLastMessage=" + this.getContinueLastMessage() + ", tokensToGenerate=" + this.getTokensToGenerate() + ", temperature=" + this.getTemperature() + ", topP=" + this.getTopP() + ", skipInfoMask=" + this.getSkipInfoMask() + ")";
    }

    public static class ChatCompletionRequestBuilder {
        private String model;
        private boolean withEmotion$set;
        private Boolean withEmotion$value;
        private boolean stream$set;
        private Boolean stream$value;
        private boolean useStandardSse$set;
        private Boolean useStandardSse$value;
        private boolean beamWidth$set;
        private Integer beamWidth$value;
        private String prompt;
        private RoleMeta roleMeta;
        private List<Message> messages;
        private boolean continueLastMessage$set;
        private Boolean continueLastMessage$value;
        private boolean tokensToGenerate$set;
        private Long tokensToGenerate$value;
        private boolean temperature$set;
        private Float temperature$value;
        private boolean topP$set;
        private Float topP$value;
        private boolean skipInfoMask$set;
        private Boolean skipInfoMask$value;

        ChatCompletionRequestBuilder() {
        }

        public ChatCompletionRequestBuilder setModel(String model) {
            this.model = model;
            return this;
        }

        public ChatCompletionRequestBuilder setWithEmotion(Boolean withEmotion) {
            this.withEmotion$value = withEmotion;
            this.withEmotion$set = true;
            return this;
        }

        public ChatCompletionRequestBuilder setStream(Boolean stream) {
            this.stream$value = stream;
            this.stream$set = true;
            return this;
        }

        public ChatCompletionRequestBuilder setUseStandardSse(Boolean useStandardSse) {
            this.useStandardSse$value = useStandardSse;
            this.useStandardSse$set = true;
            return this;
        }

        public ChatCompletionRequestBuilder setBeamWidth(Integer beamWidth) {
            this.beamWidth$value = beamWidth;
            this.beamWidth$set = true;
            return this;
        }

        public ChatCompletionRequestBuilder setPrompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public ChatCompletionRequestBuilder setRoleMeta(RoleMeta roleMeta) {
            this.roleMeta = roleMeta;
            return this;
        }

        public ChatCompletionRequestBuilder setMessages(List<Message> messages) {
            this.messages = messages;
            return this;
        }

        public ChatCompletionRequestBuilder setContinueLastMessage(Boolean continueLastMessage) {
            this.continueLastMessage$value = continueLastMessage;
            this.continueLastMessage$set = true;
            return this;
        }

        public ChatCompletionRequestBuilder setTokensToGenerate(Long tokensToGenerate) {
            this.tokensToGenerate$value = tokensToGenerate;
            this.tokensToGenerate$set = true;
            return this;
        }

        public ChatCompletionRequestBuilder setTemperature(Float temperature) {
            this.temperature$value = temperature;
            this.temperature$set = true;
            return this;
        }

        public ChatCompletionRequestBuilder setTopP(Float topP) {
            this.topP$value = topP;
            this.topP$set = true;
            return this;
        }

        public ChatCompletionRequestBuilder setSkipInfoMask(Boolean skipInfoMask) {
            this.skipInfoMask$value = skipInfoMask;
            this.skipInfoMask$set = true;
            return this;
        }

        public ChatCompletionRequest build() {
            Boolean withEmotion$value = this.withEmotion$value;
            if (!this.withEmotion$set) {
                withEmotion$value = ChatCompletionRequest.$default$withEmotion();
            }
            Boolean stream$value = this.stream$value;
            if (!this.stream$set) {
                stream$value = ChatCompletionRequest.$default$stream();
            }
            Boolean useStandardSse$value = this.useStandardSse$value;
            if (!this.useStandardSse$set) {
                useStandardSse$value = ChatCompletionRequest.$default$useStandardSse();
            }
            Integer beamWidth$value = this.beamWidth$value;
            if (!this.beamWidth$set) {
                beamWidth$value = ChatCompletionRequest.$default$beamWidth();
            }
            Boolean continueLastMessage$value = this.continueLastMessage$value;
            if (!this.continueLastMessage$set) {
                continueLastMessage$value = ChatCompletionRequest.$default$continueLastMessage();
            }
            Long tokensToGenerate$value = this.tokensToGenerate$value;
            if (!this.tokensToGenerate$set) {
                tokensToGenerate$value = ChatCompletionRequest.$default$tokensToGenerate();
            }
            Float temperature$value = this.temperature$value;
            if (!this.temperature$set) {
                temperature$value = ChatCompletionRequest.$default$temperature();
            }
            Float topP$value = this.topP$value;
            if (!this.topP$set) {
                topP$value = ChatCompletionRequest.$default$topP();
            }
            Boolean skipInfoMask$value = this.skipInfoMask$value;
            if (!this.skipInfoMask$set) {
                skipInfoMask$value = ChatCompletionRequest.$default$skipInfoMask();
            }
            return new ChatCompletionRequest(this.model, withEmotion$value, stream$value, useStandardSse$value, beamWidth$value, this.prompt, this.roleMeta, this.messages, continueLastMessage$value, tokensToGenerate$value, temperature$value, topP$value, skipInfoMask$value);
        }

        public String toString() {
            return "ChatCompletionRequest.ChatCompletionRequestBuilder(model=" + this.model + ", withEmotion$value=" + this.withEmotion$value + ", stream$value=" + this.stream$value + ", useStandardSse$value=" + this.useStandardSse$value + ", beamWidth$value=" + this.beamWidth$value + ", prompt=" + this.prompt + ", roleMeta=" + this.roleMeta + ", messages=" + this.messages + ", continueLastMessage$value=" + this.continueLastMessage$value + ", tokensToGenerate$value=" + this.tokensToGenerate$value + ", temperature$value=" + this.temperature$value + ", topP$value=" + this.topP$value + ", skipInfoMask$value=" + this.skipInfoMask$value + ")";
        }
    }

    public static class Message
    implements Input,
    Output,
    MemoryValue {
        private String senderType;
        private String text;

        Message(String senderType, String text) {
            this.senderType = senderType;
            this.text = text;
        }

        public static MessageBuilder builder() {
            return new MessageBuilder();
        }

        public MessageBuilder toBuilder() {
            return new MessageBuilder().setSenderType(this.senderType).setText(this.text);
        }

        public String getSenderType() {
            return this.senderType;
        }

        public String getText() {
            return this.text;
        }

        public void setSenderType(String senderType) {
            this.senderType = senderType;
        }

        public void setText(String text) {
            this.text = text;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Message)) {
                return false;
            }
            Message other = (Message)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$senderType = this.getSenderType();
            String other$senderType = other.getSenderType();
            if (this$senderType == null ? other$senderType != null : !this$senderType.equals(other$senderType)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            return !(this$text == null ? other$text != null : !this$text.equals(other$text));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Message;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $senderType = this.getSenderType();
            result = result * 59 + ($senderType == null ? 43 : $senderType.hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            return result;
        }

        public String toString() {
            return "ChatCompletionRequest.Message(senderType=" + this.getSenderType() + ", text=" + this.getText() + ")";
        }

        public static class MessageBuilder {
            private String senderType;
            private String text;

            MessageBuilder() {
            }

            public MessageBuilder setSenderType(String senderType) {
                this.senderType = senderType;
                return this;
            }

            public MessageBuilder setText(String text) {
                this.text = text;
                return this;
            }

            public Message build() {
                return new Message(this.senderType, this.text);
            }

            public String toString() {
                return "ChatCompletionRequest.Message.MessageBuilder(senderType=" + this.senderType + ", text=" + this.text + ")";
            }
        }
    }

    public static class RoleMeta {
        private String userName;
        private String botName;

        RoleMeta(String userName, String botName) {
            this.userName = userName;
            this.botName = botName;
        }

        public static RoleMetaBuilder builder() {
            return new RoleMetaBuilder();
        }

        public RoleMetaBuilder toBuilder() {
            return new RoleMetaBuilder().setUserName(this.userName).setBotName(this.botName);
        }

        public String getUserName() {
            return this.userName;
        }

        public String getBotName() {
            return this.botName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public void setBotName(String botName) {
            this.botName = botName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RoleMeta)) {
                return false;
            }
            RoleMeta other = (RoleMeta)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$userName = this.getUserName();
            String other$userName = other.getUserName();
            if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
                return false;
            }
            String this$botName = this.getBotName();
            String other$botName = other.getBotName();
            return !(this$botName == null ? other$botName != null : !this$botName.equals(other$botName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RoleMeta;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $userName = this.getUserName();
            result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
            String $botName = this.getBotName();
            result = result * 59 + ($botName == null ? 43 : $botName.hashCode());
            return result;
        }

        public String toString() {
            return "ChatCompletionRequest.RoleMeta(userName=" + this.getUserName() + ", botName=" + this.getBotName() + ")";
        }

        public static class RoleMetaBuilder {
            private String userName;
            private String botName;

            RoleMetaBuilder() {
            }

            public RoleMetaBuilder setUserName(String userName) {
                this.userName = userName;
                return this;
            }

            public RoleMetaBuilder setBotName(String botName) {
                this.botName = botName;
                return this;
            }

            public RoleMeta build() {
                return new RoleMeta(this.userName, this.botName);
            }

            public String toString() {
                return "ChatCompletionRequest.RoleMeta.RoleMetaBuilder(userName=" + this.userName + ", botName=" + this.botName + ")";
            }
        }
    }
}

