/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.processor.cohere.generate;

import ai.knowly.langtorch.processor.cohere.generate.CohereGenerateProcessorConfig;
import ai.knowly.langtorch.processor.cohere.generate.CohereGenerateReturnLikelihoods;
import ai.knowly.langtorch.processor.cohere.generate.CohereGenerateTruncate;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Optional;

final class AutoValue_CohereGenerateProcessorConfig
extends CohereGenerateProcessorConfig {
    private final String model;
    private final Optional<String> present;
    private final Optional<Double> temperature;
    private final Optional<Double> p;
    private final Optional<Integer> k;
    private final Optional<Integer> maxTokens;
    private final Optional<Integer> numGenerations;
    private final Optional<Double> presencePenalty;
    private final Optional<Double> frequencyPenalty;
    private final ImmutableMap<String, Float> logitBias;
    private final List<String> endSequences;
    private final List<String> stopSequences;
    private final Optional<CohereGenerateReturnLikelihoods> returnLikelihoods;
    private final Optional<CohereGenerateTruncate> truncate;

    private AutoValue_CohereGenerateProcessorConfig(String model, Optional<String> present, Optional<Double> temperature, Optional<Double> p, Optional<Integer> k, Optional<Integer> maxTokens, Optional<Integer> numGenerations, Optional<Double> presencePenalty, Optional<Double> frequencyPenalty, ImmutableMap<String, Float> logitBias, List<String> endSequences, List<String> stopSequences, Optional<CohereGenerateReturnLikelihoods> returnLikelihoods, Optional<CohereGenerateTruncate> truncate) {
        this.model = model;
        this.present = present;
        this.temperature = temperature;
        this.p = p;
        this.k = k;
        this.maxTokens = maxTokens;
        this.numGenerations = numGenerations;
        this.presencePenalty = presencePenalty;
        this.frequencyPenalty = frequencyPenalty;
        this.logitBias = logitBias;
        this.endSequences = endSequences;
        this.stopSequences = stopSequences;
        this.returnLikelihoods = returnLikelihoods;
        this.truncate = truncate;
    }

    @Override
    public String getModel() {
        return this.model;
    }

    @Override
    public Optional<String> getPresent() {
        return this.present;
    }

    @Override
    public Optional<Double> getTemperature() {
        return this.temperature;
    }

    @Override
    public Optional<Double> getP() {
        return this.p;
    }

    @Override
    public Optional<Integer> getK() {
        return this.k;
    }

    @Override
    public Optional<Integer> getMaxTokens() {
        return this.maxTokens;
    }

    @Override
    public Optional<Integer> getNumGenerations() {
        return this.numGenerations;
    }

    @Override
    public Optional<Double> getPresencePenalty() {
        return this.presencePenalty;
    }

    @Override
    public Optional<Double> getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    @Override
    public ImmutableMap<String, Float> getLogitBias() {
        return this.logitBias;
    }

    @Override
    public List<String> getEndSequences() {
        return this.endSequences;
    }

    @Override
    public List<String> getStopSequences() {
        return this.stopSequences;
    }

    @Override
    public Optional<CohereGenerateReturnLikelihoods> getReturnLikelihoods() {
        return this.returnLikelihoods;
    }

    @Override
    public Optional<CohereGenerateTruncate> getTruncate() {
        return this.truncate;
    }

    public String toString() {
        return "CohereGenerateProcessorConfig{model=" + this.model + ", present=" + this.present + ", temperature=" + this.temperature + ", p=" + this.p + ", k=" + this.k + ", maxTokens=" + this.maxTokens + ", numGenerations=" + this.numGenerations + ", presencePenalty=" + this.presencePenalty + ", frequencyPenalty=" + this.frequencyPenalty + ", logitBias=" + this.logitBias + ", endSequences=" + this.endSequences + ", stopSequences=" + this.stopSequences + ", returnLikelihoods=" + this.returnLikelihoods + ", truncate=" + this.truncate + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CohereGenerateProcessorConfig) {
            CohereGenerateProcessorConfig that = (CohereGenerateProcessorConfig)o;
            return this.model.equals(that.getModel()) && this.present.equals(that.getPresent()) && this.temperature.equals(that.getTemperature()) && this.p.equals(that.getP()) && this.k.equals(that.getK()) && this.maxTokens.equals(that.getMaxTokens()) && this.numGenerations.equals(that.getNumGenerations()) && this.presencePenalty.equals(that.getPresencePenalty()) && this.frequencyPenalty.equals(that.getFrequencyPenalty()) && this.logitBias.equals(that.getLogitBias()) && this.endSequences.equals(that.getEndSequences()) && this.stopSequences.equals(that.getStopSequences()) && this.returnLikelihoods.equals(that.getReturnLikelihoods()) && this.truncate.equals(that.getTruncate());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.model.hashCode();
        h$ *= 1000003;
        h$ ^= this.present.hashCode();
        h$ *= 1000003;
        h$ ^= this.temperature.hashCode();
        h$ *= 1000003;
        h$ ^= this.p.hashCode();
        h$ *= 1000003;
        h$ ^= this.k.hashCode();
        h$ *= 1000003;
        h$ ^= this.maxTokens.hashCode();
        h$ *= 1000003;
        h$ ^= this.numGenerations.hashCode();
        h$ *= 1000003;
        h$ ^= this.presencePenalty.hashCode();
        h$ *= 1000003;
        h$ ^= this.frequencyPenalty.hashCode();
        h$ *= 1000003;
        h$ ^= this.logitBias.hashCode();
        h$ *= 1000003;
        h$ ^= this.endSequences.hashCode();
        h$ *= 1000003;
        h$ ^= this.stopSequences.hashCode();
        h$ *= 1000003;
        h$ ^= this.returnLikelihoods.hashCode();
        h$ *= 1000003;
        return h$ ^= this.truncate.hashCode();
    }

    @Override
    public CohereGenerateProcessorConfig.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends CohereGenerateProcessorConfig.Builder {
        private String model;
        private Optional<String> present = Optional.empty();
        private Optional<Double> temperature = Optional.empty();
        private Optional<Double> p = Optional.empty();
        private Optional<Integer> k = Optional.empty();
        private Optional<Integer> maxTokens = Optional.empty();
        private Optional<Integer> numGenerations = Optional.empty();
        private Optional<Double> presencePenalty = Optional.empty();
        private Optional<Double> frequencyPenalty = Optional.empty();
        private ImmutableMap<String, Float> logitBias;
        private List<String> endSequences;
        private List<String> stopSequences;
        private Optional<CohereGenerateReturnLikelihoods> returnLikelihoods = Optional.empty();
        private Optional<CohereGenerateTruncate> truncate = Optional.empty();

        Builder() {
        }

        private Builder(CohereGenerateProcessorConfig source) {
            this.model = source.getModel();
            this.present = source.getPresent();
            this.temperature = source.getTemperature();
            this.p = source.getP();
            this.k = source.getK();
            this.maxTokens = source.getMaxTokens();
            this.numGenerations = source.getNumGenerations();
            this.presencePenalty = source.getPresencePenalty();
            this.frequencyPenalty = source.getFrequencyPenalty();
            this.logitBias = source.getLogitBias();
            this.endSequences = source.getEndSequences();
            this.stopSequences = source.getStopSequences();
            this.returnLikelihoods = source.getReturnLikelihoods();
            this.truncate = source.getTruncate();
        }

        @Override
        public CohereGenerateProcessorConfig.Builder setModel(String model) {
            if (model == null) {
                throw new NullPointerException("Null model");
            }
            this.model = model;
            return this;
        }

        @Override
        public CohereGenerateProcessorConfig.Builder setPresent(String present) {
            this.present = Optional.of(present);
            return this;
        }

        @Override
        public CohereGenerateProcessorConfig.Builder setTemperature(double temperature) {
            this.temperature = Optional.of(temperature);
            return this;
        }

        @Override
        public CohereGenerateProcessorConfig.Builder setP(double p) {
            this.p = Optional.of(p);
            return this;
        }

        @Override
        public CohereGenerateProcessorConfig.Builder setK(int k) {
            this.k = Optional.of(k);
            return this;
        }

        @Override
        public CohereGenerateProcessorConfig.Builder setMaxTokens(int maxTokens) {
            this.maxTokens = Optional.of(maxTokens);
            return this;
        }

        @Override
        public CohereGenerateProcessorConfig.Builder setNumGenerations(int numGenerations) {
            this.numGenerations = Optional.of(numGenerations);
            return this;
        }

        @Override
        public CohereGenerateProcessorConfig.Builder setPresencePenalty(double presencePenalty) {
            this.presencePenalty = Optional.of(presencePenalty);
            return this;
        }

        @Override
        public CohereGenerateProcessorConfig.Builder setFrequencyPenalty(double frequencyPenalty) {
            this.frequencyPenalty = Optional.of(frequencyPenalty);
            return this;
        }

        @Override
        public CohereGenerateProcessorConfig.Builder setLogitBias(ImmutableMap<String, Float> logitBias) {
            if (logitBias == null) {
                throw new NullPointerException("Null logitBias");
            }
            this.logitBias = logitBias;
            return this;
        }

        @Override
        public CohereGenerateProcessorConfig.Builder setEndSequences(List<String> endSequences) {
            if (endSequences == null) {
                throw new NullPointerException("Null endSequences");
            }
            this.endSequences = endSequences;
            return this;
        }

        @Override
        public CohereGenerateProcessorConfig.Builder setStopSequences(List<String> stopSequences) {
            if (stopSequences == null) {
                throw new NullPointerException("Null stopSequences");
            }
            this.stopSequences = stopSequences;
            return this;
        }

        @Override
        public CohereGenerateProcessorConfig.Builder setReturnLikelihoods(CohereGenerateReturnLikelihoods returnLikelihoods) {
            this.returnLikelihoods = Optional.of(returnLikelihoods);
            return this;
        }

        @Override
        public CohereGenerateProcessorConfig.Builder setTruncate(CohereGenerateTruncate truncate) {
            this.truncate = Optional.of(truncate);
            return this;
        }

        @Override
        public CohereGenerateProcessorConfig build() {
            if (this.model == null || this.logitBias == null || this.endSequences == null || this.stopSequences == null) {
                StringBuilder missing = new StringBuilder();
                if (this.model == null) {
                    missing.append(" model");
                }
                if (this.logitBias == null) {
                    missing.append(" logitBias");
                }
                if (this.endSequences == null) {
                    missing.append(" endSequences");
                }
                if (this.stopSequences == null) {
                    missing.append(" stopSequences");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_CohereGenerateProcessorConfig(this.model, this.present, this.temperature, this.p, this.k, this.maxTokens, this.numGenerations, this.presencePenalty, this.frequencyPenalty, this.logitBias, this.endSequences, this.stopSequences, this.returnLikelihoods, this.truncate);
        }
    }
}

