/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.processor.minimax.chat;

import ai.knowly.langtorch.llm.minimax.MiniMaxService;
import ai.knowly.langtorch.llm.minimax.schema.dto.completion.ChatCompletionRequest;
import ai.knowly.langtorch.llm.minimax.schema.dto.completion.ChatCompletionResult;
import ai.knowly.langtorch.processor.Processor;
import ai.knowly.langtorch.processor.minimax.chat.MiniMaxChatProcessorConfig;
import ai.knowly.langtorch.processor.minimax.chat.MiniMaxChatProcessorRequestConverter;
import ai.knowly.langtorch.schema.chat.ChatMessage;
import ai.knowly.langtorch.schema.chat.MiniMaxBotMessage;
import ai.knowly.langtorch.schema.text.MultiChatMessage;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import javax.inject.Inject;

public class MiniMaxChatProcessor
implements Processor<MultiChatMessage, ChatMessage> {
    private final MiniMaxService miniMaxService;
    private MiniMaxChatProcessorConfig miniMaxChatProcessorConfig;

    @Inject
    public MiniMaxChatProcessor(MiniMaxService miniMaxService, MiniMaxChatProcessorConfig miniMaxChatProcessorConfig) {
        this.miniMaxService = miniMaxService;
        this.miniMaxChatProcessorConfig = miniMaxChatProcessorConfig;
    }

    @Override
    public ChatMessage run(MultiChatMessage inputData) {
        ChatCompletionRequest chatCompletionRequest = MiniMaxChatProcessorRequestConverter.convert(this.miniMaxChatProcessorConfig, inputData);
        ChatCompletionResult chatCompletion = this.miniMaxService.createChatCompletion(chatCompletionRequest);
        List<ChatCompletionResult.Choices> choices = chatCompletion.getChoices();
        ChatCompletionResult.Choices choicesResult = choices.get(0);
        return MiniMaxBotMessage.of(choicesResult.getText());
    }

    @Override
    public ListenableFuture<ChatMessage> runAsync(MultiChatMessage inputData) {
        ChatCompletionRequest chatCompletionRequest = MiniMaxChatProcessorRequestConverter.convert(this.miniMaxChatProcessorConfig, inputData);
        ListenableFuture<ChatCompletionResult> chatCompletionAsync = this.miniMaxService.createChatCompletionAsync(chatCompletionRequest);
        return FluentFuture.from(chatCompletionAsync).transform(chatCompletion -> {
            this.miniMaxService.checkResp(chatCompletion.getBaseResp());
            List<ChatCompletionResult.Choices> choices = chatCompletion.getChoices();
            ChatCompletionResult.Choices choicesResult = choices.get(0);
            return MiniMaxBotMessage.of(choicesResult.getText());
        }, MoreExecutors.directExecutor());
    }
}

