/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.processor.minimax.embeddings;

import ai.knowly.langtorch.llm.minimax.MiniMaxService;
import ai.knowly.langtorch.llm.minimax.schema.dto.embedding.EmbeddingResult;
import ai.knowly.langtorch.processor.EmbeddingProcessor;
import ai.knowly.langtorch.processor.minimax.embeddings.MiniMaxEmbeddingsProcessorConfig;
import ai.knowly.langtorch.processor.minimax.embeddings.MiniMaxEmbeddingsProcessorRequestConverter;
import ai.knowly.langtorch.schema.embeddings.Embedding;
import ai.knowly.langtorch.schema.embeddings.EmbeddingInput;
import ai.knowly.langtorch.schema.embeddings.EmbeddingOutput;
import ai.knowly.langtorch.schema.embeddings.EmbeddingType;
import ai.knowly.langtorch.schema.embeddings.MiniMaxEmbeddingTypeScene;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import java.util.concurrent.Executor;

public class MiniMaxEmbeddingsProcessor
implements EmbeddingProcessor {
    private final MiniMaxService miniMaxService;
    private final MiniMaxEmbeddingsProcessorConfig miniMaxEmbeddingsProcessorConfig;

    public MiniMaxEmbeddingsProcessor(MiniMaxService miniMaxService, MiniMaxEmbeddingsProcessorConfig miniMaxEmbeddingsProcessorConfig) {
        this.miniMaxService = miniMaxService;
        this.miniMaxEmbeddingsProcessorConfig = miniMaxEmbeddingsProcessorConfig;
    }

    @Override
    public EmbeddingOutput run(EmbeddingInput inputData) {
        EmbeddingResult embeddingResult = this.miniMaxService.createEmbeddings(MiniMaxEmbeddingsProcessorRequestConverter.convert(inputData.getModel(), inputData.getInput(), MiniMaxEmbeddingTypeScene.DB.toString()));
        return EmbeddingOutput.of(EmbeddingType.MINI_MAX, (List)embeddingResult.getVectors().stream().map(Embedding::ofFloatVector).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public ListenableFuture<EmbeddingOutput> runAsync(EmbeddingInput inputData) {
        ListenableFuture<EmbeddingResult> embeddingResult = this.miniMaxService.createEmbeddingsAsync(MiniMaxEmbeddingsProcessorRequestConverter.convert(inputData.getModel(), inputData.getInput(), MiniMaxEmbeddingTypeScene.DB.toString()));
        return Futures.transform(embeddingResult, result -> {
            this.miniMaxService.checkResp(result.getBaseResp());
            return EmbeddingOutput.of(EmbeddingType.MINI_MAX, (List)result.getVectors().stream().map(Embedding::ofFloatVector).collect(ImmutableList.toImmutableList()));
        }, (Executor)MoreExecutors.directExecutor());
    }
}

