/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.processor.openai.chat;

import ai.knowly.langtorch.processor.openai.chat.OpenAIChatProcessorConfig;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

final class AutoValue_OpenAIChatProcessorConfig
extends OpenAIChatProcessorConfig {
    private final String model;
    private final Optional<Double> temperature;
    private final Optional<Double> topP;
    private final Optional<Integer> n;
    private final Optional<Boolean> stream;
    private final ImmutableList<String> stop;
    private final Optional<Integer> maxTokens;
    private final Optional<Double> presencePenalty;
    private final Optional<Double> frequencyPenalty;
    private final ImmutableMap<String, Integer> logitBias;
    private final Optional<String> user;

    private AutoValue_OpenAIChatProcessorConfig(String model, Optional<Double> temperature, Optional<Double> topP, Optional<Integer> n, Optional<Boolean> stream, ImmutableList<String> stop, Optional<Integer> maxTokens, Optional<Double> presencePenalty, Optional<Double> frequencyPenalty, ImmutableMap<String, Integer> logitBias, Optional<String> user) {
        this.model = model;
        this.temperature = temperature;
        this.topP = topP;
        this.n = n;
        this.stream = stream;
        this.stop = stop;
        this.maxTokens = maxTokens;
        this.presencePenalty = presencePenalty;
        this.frequencyPenalty = frequencyPenalty;
        this.logitBias = logitBias;
        this.user = user;
    }

    @Override
    public String getModel() {
        return this.model;
    }

    @Override
    public Optional<Double> getTemperature() {
        return this.temperature;
    }

    @Override
    public Optional<Double> getTopP() {
        return this.topP;
    }

    @Override
    public Optional<Integer> getN() {
        return this.n;
    }

    @Override
    public Optional<Boolean> getStream() {
        return this.stream;
    }

    @Override
    public ImmutableList<String> getStop() {
        return this.stop;
    }

    @Override
    public Optional<Integer> getMaxTokens() {
        return this.maxTokens;
    }

    @Override
    public Optional<Double> getPresencePenalty() {
        return this.presencePenalty;
    }

    @Override
    public Optional<Double> getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    @Override
    public ImmutableMap<String, Integer> getLogitBias() {
        return this.logitBias;
    }

    @Override
    public Optional<String> getUser() {
        return this.user;
    }

    public String toString() {
        return "OpenAIChatProcessorConfig{model=" + this.model + ", temperature=" + this.temperature + ", topP=" + this.topP + ", n=" + this.n + ", stream=" + this.stream + ", stop=" + this.stop + ", maxTokens=" + this.maxTokens + ", presencePenalty=" + this.presencePenalty + ", frequencyPenalty=" + this.frequencyPenalty + ", logitBias=" + this.logitBias + ", user=" + this.user + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof OpenAIChatProcessorConfig) {
            OpenAIChatProcessorConfig that = (OpenAIChatProcessorConfig)o;
            return this.model.equals(that.getModel()) && this.temperature.equals(that.getTemperature()) && this.topP.equals(that.getTopP()) && this.n.equals(that.getN()) && this.stream.equals(that.getStream()) && this.stop.equals(that.getStop()) && this.maxTokens.equals(that.getMaxTokens()) && this.presencePenalty.equals(that.getPresencePenalty()) && this.frequencyPenalty.equals(that.getFrequencyPenalty()) && this.logitBias.equals(that.getLogitBias()) && this.user.equals(that.getUser());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.model.hashCode();
        h$ *= 1000003;
        h$ ^= this.temperature.hashCode();
        h$ *= 1000003;
        h$ ^= this.topP.hashCode();
        h$ *= 1000003;
        h$ ^= this.n.hashCode();
        h$ *= 1000003;
        h$ ^= this.stream.hashCode();
        h$ *= 1000003;
        h$ ^= this.stop.hashCode();
        h$ *= 1000003;
        h$ ^= this.maxTokens.hashCode();
        h$ *= 1000003;
        h$ ^= this.presencePenalty.hashCode();
        h$ *= 1000003;
        h$ ^= this.frequencyPenalty.hashCode();
        h$ *= 1000003;
        h$ ^= this.logitBias.hashCode();
        h$ *= 1000003;
        return h$ ^= this.user.hashCode();
    }

    @Override
    public OpenAIChatProcessorConfig.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends OpenAIChatProcessorConfig.Builder {
        private String model;
        private Optional<Double> temperature = Optional.empty();
        private Optional<Double> topP = Optional.empty();
        private Optional<Integer> n = Optional.empty();
        private Optional<Boolean> stream = Optional.empty();
        private ImmutableList<String> stop;
        private Optional<Integer> maxTokens = Optional.empty();
        private Optional<Double> presencePenalty = Optional.empty();
        private Optional<Double> frequencyPenalty = Optional.empty();
        private ImmutableMap<String, Integer> logitBias;
        private Optional<String> user = Optional.empty();

        Builder() {
        }

        private Builder(OpenAIChatProcessorConfig source) {
            this.model = source.getModel();
            this.temperature = source.getTemperature();
            this.topP = source.getTopP();
            this.n = source.getN();
            this.stream = source.getStream();
            this.stop = source.getStop();
            this.maxTokens = source.getMaxTokens();
            this.presencePenalty = source.getPresencePenalty();
            this.frequencyPenalty = source.getFrequencyPenalty();
            this.logitBias = source.getLogitBias();
            this.user = source.getUser();
        }

        @Override
        public OpenAIChatProcessorConfig.Builder setModel(String model) {
            if (model == null) {
                throw new NullPointerException("Null model");
            }
            this.model = model;
            return this;
        }

        @Override
        public OpenAIChatProcessorConfig.Builder setTemperature(Double temperature) {
            this.temperature = Optional.of(temperature);
            return this;
        }

        @Override
        public OpenAIChatProcessorConfig.Builder setTopP(Double topP) {
            this.topP = Optional.of(topP);
            return this;
        }

        @Override
        public OpenAIChatProcessorConfig.Builder setN(Integer n) {
            this.n = Optional.of(n);
            return this;
        }

        @Override
        public OpenAIChatProcessorConfig.Builder setStream(Boolean stream) {
            this.stream = Optional.of(stream);
            return this;
        }

        @Override
        public OpenAIChatProcessorConfig.Builder setStop(List<String> stop) {
            this.stop = ImmutableList.copyOf(stop);
            return this;
        }

        @Override
        public OpenAIChatProcessorConfig.Builder setMaxTokens(Integer maxTokens) {
            this.maxTokens = Optional.of(maxTokens);
            return this;
        }

        @Override
        public OpenAIChatProcessorConfig.Builder setPresencePenalty(Double presencePenalty) {
            this.presencePenalty = Optional.of(presencePenalty);
            return this;
        }

        @Override
        public OpenAIChatProcessorConfig.Builder setFrequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = Optional.of(frequencyPenalty);
            return this;
        }

        @Override
        public OpenAIChatProcessorConfig.Builder setLogitBias(Map<String, Integer> logitBias) {
            this.logitBias = ImmutableMap.copyOf(logitBias);
            return this;
        }

        @Override
        public OpenAIChatProcessorConfig.Builder setUser(String user) {
            this.user = Optional.of(user);
            return this;
        }

        @Override
        public OpenAIChatProcessorConfig build() {
            if (this.model == null || this.stop == null || this.logitBias == null) {
                StringBuilder missing = new StringBuilder();
                if (this.model == null) {
                    missing.append(" model");
                }
                if (this.stop == null) {
                    missing.append(" stop");
                }
                if (this.logitBias == null) {
                    missing.append(" logitBias");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_OpenAIChatProcessorConfig(this.model, this.temperature, this.topP, this.n, this.stream, this.stop, this.maxTokens, this.presencePenalty, this.frequencyPenalty, this.logitBias, this.user);
        }
    }
}

