/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.processor.openai.chat;

import ai.knowly.langtorch.llm.openai.schema.dto.completion.chat.ChatCompletionRequest;
import ai.knowly.langtorch.processor.openai.chat.OpenAIChatProcessorConfig;
import ai.knowly.langtorch.schema.chat.ChatMessage;
import java.util.List;
import java.util.Map;

public final class OpenAIChatProcessorRequestConverter {
    private OpenAIChatProcessorRequestConverter() {
    }

    public static ChatCompletionRequest convert(OpenAIChatProcessorConfig openAIChatProcessorConfig, List<ChatMessage> messages) {
        ChatCompletionRequest.ChatCompletionRequestBuilder completionRequestBuilder = ChatCompletionRequest.builder().setModel(openAIChatProcessorConfig.getModel()).setMessages(messages);
        openAIChatProcessorConfig.getTemperature().ifPresent(completionRequestBuilder::setTemperature);
        openAIChatProcessorConfig.getTopP().ifPresent(completionRequestBuilder::setTopP);
        openAIChatProcessorConfig.getN().ifPresent(completionRequestBuilder::setN);
        openAIChatProcessorConfig.getStream().ifPresent(completionRequestBuilder::setStream);
        if (!openAIChatProcessorConfig.getStop().isEmpty()) {
            completionRequestBuilder.setStop((List<String>)openAIChatProcessorConfig.getStop());
        }
        openAIChatProcessorConfig.getMaxTokens().ifPresent(completionRequestBuilder::setMaxTokens);
        openAIChatProcessorConfig.getPresencePenalty().ifPresent(completionRequestBuilder::setPresencePenalty);
        openAIChatProcessorConfig.getFrequencyPenalty().ifPresent(completionRequestBuilder::setFrequencyPenalty);
        completionRequestBuilder.setLogitBias((Map<String, Integer>)openAIChatProcessorConfig.getLogitBias());
        openAIChatProcessorConfig.getUser().ifPresent(completionRequestBuilder::setUser);
        return completionRequestBuilder.build();
    }
}

