/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.processor.openai.embedding;

import ai.knowly.langtorch.llm.openai.OpenAIService;
import ai.knowly.langtorch.llm.openai.schema.dto.embedding.EmbeddingResult;
import ai.knowly.langtorch.processor.EmbeddingProcessor;
import ai.knowly.langtorch.processor.openai.embedding.OpenAIEmbeddingsProcessorConfig;
import ai.knowly.langtorch.processor.openai.embedding.OpenAIEmbeddingsProcessorRequestConverter;
import ai.knowly.langtorch.schema.embeddings.Embedding;
import ai.knowly.langtorch.schema.embeddings.EmbeddingInput;
import ai.knowly.langtorch.schema.embeddings.EmbeddingOutput;
import ai.knowly.langtorch.schema.embeddings.EmbeddingType;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import java.util.concurrent.Executor;
import javax.inject.Inject;

public class OpenAIEmbeddingProcessor
implements EmbeddingProcessor {
    private final OpenAIService openAIService;
    private final OpenAIEmbeddingsProcessorConfig openAIEmbeddingsProcessorConfig;

    @Inject
    public OpenAIEmbeddingProcessor(OpenAIService openAiApi, OpenAIEmbeddingsProcessorConfig openAIEmbeddingsProcessorConfig) {
        this.openAIService = openAiApi;
        this.openAIEmbeddingsProcessorConfig = openAIEmbeddingsProcessorConfig;
    }

    @Override
    public EmbeddingOutput run(EmbeddingInput inputData) {
        EmbeddingResult embeddingResult = this.openAIService.createEmbeddings(OpenAIEmbeddingsProcessorRequestConverter.convert(this.openAIEmbeddingsProcessorConfig, inputData.getModel(), inputData.getInput()));
        return EmbeddingOutput.of(EmbeddingType.OPEN_AI, (List)embeddingResult.getData().stream().map(embedding -> Embedding.of(embedding.getValue())).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public ListenableFuture<EmbeddingOutput> runAsync(EmbeddingInput inputData) {
        ListenableFuture<EmbeddingResult> embeddingResult = this.openAIService.createEmbeddingsAsync(OpenAIEmbeddingsProcessorRequestConverter.convert(this.openAIEmbeddingsProcessorConfig, inputData.getModel(), inputData.getInput()));
        return Futures.transform(embeddingResult, result -> EmbeddingOutput.of(EmbeddingType.OPEN_AI, (List)result.getData().stream().map(embedding -> Embedding.of(embedding.getValue())).collect(ImmutableList.toImmutableList())), (Executor)MoreExecutors.directExecutor());
    }
}

