/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.processor.openai.text;

import ai.knowly.langtorch.processor.openai.text.OpenAITextProcessorConfig;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

final class AutoValue_OpenAITextProcessorConfig
extends OpenAITextProcessorConfig {
    private final String model;
    private final Optional<String> suffix;
    private final Optional<Integer> maxTokens;
    private final Optional<Double> temperature;
    private final Optional<Double> topP;
    private final Optional<Integer> n;
    private final Optional<Boolean> stream;
    private final Optional<Integer> logprobs;
    private final Optional<Boolean> echo;
    private final ImmutableList<String> stop;
    private final Optional<Double> presencePenalty;
    private final Optional<Double> frequencyPenalty;
    private final Optional<Integer> bestOf;
    private final ImmutableMap<String, Integer> logitBias;
    private final Optional<String> user;

    private AutoValue_OpenAITextProcessorConfig(String model, Optional<String> suffix, Optional<Integer> maxTokens, Optional<Double> temperature, Optional<Double> topP, Optional<Integer> n, Optional<Boolean> stream, Optional<Integer> logprobs, Optional<Boolean> echo, ImmutableList<String> stop, Optional<Double> presencePenalty, Optional<Double> frequencyPenalty, Optional<Integer> bestOf, ImmutableMap<String, Integer> logitBias, Optional<String> user) {
        this.model = model;
        this.suffix = suffix;
        this.maxTokens = maxTokens;
        this.temperature = temperature;
        this.topP = topP;
        this.n = n;
        this.stream = stream;
        this.logprobs = logprobs;
        this.echo = echo;
        this.stop = stop;
        this.presencePenalty = presencePenalty;
        this.frequencyPenalty = frequencyPenalty;
        this.bestOf = bestOf;
        this.logitBias = logitBias;
        this.user = user;
    }

    @Override
    public String getModel() {
        return this.model;
    }

    @Override
    public Optional<String> getSuffix() {
        return this.suffix;
    }

    @Override
    public Optional<Integer> getMaxTokens() {
        return this.maxTokens;
    }

    @Override
    public Optional<Double> getTemperature() {
        return this.temperature;
    }

    @Override
    public Optional<Double> getTopP() {
        return this.topP;
    }

    @Override
    public Optional<Integer> getN() {
        return this.n;
    }

    @Override
    public Optional<Boolean> getStream() {
        return this.stream;
    }

    @Override
    public Optional<Integer> getLogprobs() {
        return this.logprobs;
    }

    @Override
    public Optional<Boolean> getEcho() {
        return this.echo;
    }

    @Override
    public ImmutableList<String> getStop() {
        return this.stop;
    }

    @Override
    public Optional<Double> getPresencePenalty() {
        return this.presencePenalty;
    }

    @Override
    public Optional<Double> getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    @Override
    public Optional<Integer> getBestOf() {
        return this.bestOf;
    }

    @Override
    public ImmutableMap<String, Integer> getLogitBias() {
        return this.logitBias;
    }

    @Override
    public Optional<String> getUser() {
        return this.user;
    }

    public String toString() {
        return "OpenAITextProcessorConfig{model=" + this.model + ", suffix=" + this.suffix + ", maxTokens=" + this.maxTokens + ", temperature=" + this.temperature + ", topP=" + this.topP + ", n=" + this.n + ", stream=" + this.stream + ", logprobs=" + this.logprobs + ", echo=" + this.echo + ", stop=" + this.stop + ", presencePenalty=" + this.presencePenalty + ", frequencyPenalty=" + this.frequencyPenalty + ", bestOf=" + this.bestOf + ", logitBias=" + this.logitBias + ", user=" + this.user + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof OpenAITextProcessorConfig) {
            OpenAITextProcessorConfig that = (OpenAITextProcessorConfig)o;
            return this.model.equals(that.getModel()) && this.suffix.equals(that.getSuffix()) && this.maxTokens.equals(that.getMaxTokens()) && this.temperature.equals(that.getTemperature()) && this.topP.equals(that.getTopP()) && this.n.equals(that.getN()) && this.stream.equals(that.getStream()) && this.logprobs.equals(that.getLogprobs()) && this.echo.equals(that.getEcho()) && this.stop.equals(that.getStop()) && this.presencePenalty.equals(that.getPresencePenalty()) && this.frequencyPenalty.equals(that.getFrequencyPenalty()) && this.bestOf.equals(that.getBestOf()) && this.logitBias.equals(that.getLogitBias()) && this.user.equals(that.getUser());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.model.hashCode();
        h$ *= 1000003;
        h$ ^= this.suffix.hashCode();
        h$ *= 1000003;
        h$ ^= this.maxTokens.hashCode();
        h$ *= 1000003;
        h$ ^= this.temperature.hashCode();
        h$ *= 1000003;
        h$ ^= this.topP.hashCode();
        h$ *= 1000003;
        h$ ^= this.n.hashCode();
        h$ *= 1000003;
        h$ ^= this.stream.hashCode();
        h$ *= 1000003;
        h$ ^= this.logprobs.hashCode();
        h$ *= 1000003;
        h$ ^= this.echo.hashCode();
        h$ *= 1000003;
        h$ ^= this.stop.hashCode();
        h$ *= 1000003;
        h$ ^= this.presencePenalty.hashCode();
        h$ *= 1000003;
        h$ ^= this.frequencyPenalty.hashCode();
        h$ *= 1000003;
        h$ ^= this.bestOf.hashCode();
        h$ *= 1000003;
        h$ ^= this.logitBias.hashCode();
        h$ *= 1000003;
        return h$ ^= this.user.hashCode();
    }

    @Override
    OpenAITextProcessorConfig.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends OpenAITextProcessorConfig.Builder {
        private String model;
        private Optional<String> suffix = Optional.empty();
        private Optional<Integer> maxTokens = Optional.empty();
        private Optional<Double> temperature = Optional.empty();
        private Optional<Double> topP = Optional.empty();
        private Optional<Integer> n = Optional.empty();
        private Optional<Boolean> stream = Optional.empty();
        private Optional<Integer> logprobs = Optional.empty();
        private Optional<Boolean> echo = Optional.empty();
        private ImmutableList<String> stop;
        private Optional<Double> presencePenalty = Optional.empty();
        private Optional<Double> frequencyPenalty = Optional.empty();
        private Optional<Integer> bestOf = Optional.empty();
        private ImmutableMap<String, Integer> logitBias;
        private Optional<String> user = Optional.empty();

        Builder() {
        }

        private Builder(OpenAITextProcessorConfig source) {
            this.model = source.getModel();
            this.suffix = source.getSuffix();
            this.maxTokens = source.getMaxTokens();
            this.temperature = source.getTemperature();
            this.topP = source.getTopP();
            this.n = source.getN();
            this.stream = source.getStream();
            this.logprobs = source.getLogprobs();
            this.echo = source.getEcho();
            this.stop = source.getStop();
            this.presencePenalty = source.getPresencePenalty();
            this.frequencyPenalty = source.getFrequencyPenalty();
            this.bestOf = source.getBestOf();
            this.logitBias = source.getLogitBias();
            this.user = source.getUser();
        }

        @Override
        public OpenAITextProcessorConfig.Builder setModel(String model) {
            if (model == null) {
                throw new NullPointerException("Null model");
            }
            this.model = model;
            return this;
        }

        @Override
        public OpenAITextProcessorConfig.Builder setSuffix(String suffix) {
            this.suffix = Optional.of(suffix);
            return this;
        }

        @Override
        public OpenAITextProcessorConfig.Builder setMaxTokens(Integer maxTokens) {
            this.maxTokens = Optional.of(maxTokens);
            return this;
        }

        @Override
        public OpenAITextProcessorConfig.Builder setTemperature(Double temperature) {
            this.temperature = Optional.of(temperature);
            return this;
        }

        @Override
        public OpenAITextProcessorConfig.Builder setTopP(Double topP) {
            this.topP = Optional.of(topP);
            return this;
        }

        @Override
        public OpenAITextProcessorConfig.Builder setN(Integer n) {
            this.n = Optional.of(n);
            return this;
        }

        @Override
        public OpenAITextProcessorConfig.Builder setStream(Boolean stream) {
            this.stream = Optional.of(stream);
            return this;
        }

        @Override
        public OpenAITextProcessorConfig.Builder setLogprobs(Integer logprobs) {
            this.logprobs = Optional.of(logprobs);
            return this;
        }

        @Override
        public OpenAITextProcessorConfig.Builder setEcho(Boolean echo) {
            this.echo = Optional.of(echo);
            return this;
        }

        @Override
        public OpenAITextProcessorConfig.Builder setStop(List<String> stop) {
            this.stop = ImmutableList.copyOf(stop);
            return this;
        }

        @Override
        public OpenAITextProcessorConfig.Builder setPresencePenalty(Double presencePenalty) {
            this.presencePenalty = Optional.of(presencePenalty);
            return this;
        }

        @Override
        public OpenAITextProcessorConfig.Builder setFrequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = Optional.of(frequencyPenalty);
            return this;
        }

        @Override
        public OpenAITextProcessorConfig.Builder setBestOf(Integer bestOf) {
            this.bestOf = Optional.of(bestOf);
            return this;
        }

        @Override
        public OpenAITextProcessorConfig.Builder setLogitBias(Map<String, Integer> logitBias) {
            this.logitBias = ImmutableMap.copyOf(logitBias);
            return this;
        }

        @Override
        public OpenAITextProcessorConfig.Builder setUser(String user) {
            this.user = Optional.of(user);
            return this;
        }

        @Override
        public OpenAITextProcessorConfig build() {
            if (this.model == null || this.stop == null || this.logitBias == null) {
                StringBuilder missing = new StringBuilder();
                if (this.model == null) {
                    missing.append(" model");
                }
                if (this.stop == null) {
                    missing.append(" stop");
                }
                if (this.logitBias == null) {
                    missing.append(" logitBias");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_OpenAITextProcessorConfig(this.model, this.suffix, this.maxTokens, this.temperature, this.topP, this.n, this.stream, this.logprobs, this.echo, this.stop, this.presencePenalty, this.frequencyPenalty, this.bestOf, this.logitBias, this.user);
        }
    }
}

