/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.prompt.manager;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;

public class OptionalTypeAdapter<T>
extends TypeAdapter<Optional<T>> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            Class rawType = typeToken.getRawType();
            if (rawType != Optional.class) {
                return null;
            }
            Type[] typeArgs = ((ParameterizedType)typeToken.getType()).getActualTypeArguments();
            TypeAdapter adapter = gson.getAdapter(TypeToken.get((Type)typeArgs[0]));
            return new OptionalTypeAdapter(adapter);
        }
    };
    private final TypeAdapter<T> delegate;

    public OptionalTypeAdapter(TypeAdapter<T> delegate) {
        this.delegate = delegate;
    }

    public Optional<T> read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return Optional.empty();
        }
        Object value = this.delegate.read(in);
        return Optional.ofNullable(value);
    }

    public void write(JsonWriter out, Optional<T> value) throws IOException {
        if (value.isPresent()) {
            this.delegate.write(out, value.get());
        } else {
            out.nullValue();
        }
    }
}

