/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.prompt.manager;

import ai.knowly.langtorch.prompt.manager.FileLoadingException;
import ai.knowly.langtorch.prompt.manager.FileSaveException;
import ai.knowly.langtorch.prompt.manager.OptionalTypeAdapter;
import ai.knowly.langtorch.prompt.manager.PromptManagerConfig;
import ai.knowly.langtorch.prompt.manager.PromptTemplateTypeAdapter;
import ai.knowly.langtorch.prompt.template.PromptTemplate;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public final class PromptManager {
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(PromptTemplate.class, (Object)new PromptTemplateTypeAdapter()).registerTypeAdapterFactory(OptionalTypeAdapter.FACTORY).create();
    private static final String DEFAULT_FILE_NAME = "prompt-manager.json";
    private final Map<Long, PromptTemplate> promptTemplateVersions;

    private PromptManager(Map<Long, PromptTemplate> promptTemplateVersions) {
        this.promptTemplateVersions = promptTemplateVersions;
    }

    public static PromptManager create() {
        return new PromptManager(new HashMap<Long, PromptTemplate>());
    }

    private static PromptManager fromJson(String json) {
        PromptManagerConfig config = (PromptManagerConfig)gson.fromJson(json, PromptManagerConfig.class);
        return new PromptManager(config.getPromptTemplates());
    }

    public static PromptManager fromFile(String folderName) {
        return PromptManager.fromFile(folderName, DEFAULT_FILE_NAME);
    }

    public static PromptManager fromFile(String folderName, String fileName) {
        PromptManager promptManager;
        String path = String.format("%s/%s", folderName, fileName);
        FileInputStream inputStream = new FileInputStream(path);
        try {
            String json = IOUtils.toString((InputStream)inputStream, (Charset)Charset.defaultCharset());
            promptManager = PromptManager.fromJson(json);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new FileLoadingException(e);
            }
        }
        inputStream.close();
        return promptManager;
    }

    public void toFile(String folderName) {
        this.toFile(folderName, DEFAULT_FILE_NAME);
    }

    public void toFile(String folderName, String fileName) {
        String toWriteFileName = fileName.contains(".json") ? fileName : fileName + ".json";
        try (FileWriter fileWriter = new FileWriter(folderName + "/" + toWriteFileName);){
            fileWriter.write(this.toJson());
        }
        catch (IOException e) {
            throw new FileSaveException(e);
        }
    }

    private String toJson() {
        return gson.toJson((Object)PromptManagerConfig.create(this.promptTemplateVersions));
    }

    public PromptTemplate getPromptTemplate(long version) {
        return this.promptTemplateVersions.get(version);
    }

    public boolean containsVersion(long version) {
        return this.promptTemplateVersions.containsKey(version);
    }

    public PromptManager addPromptTemplate(long version, PromptTemplate promptTemplate) {
        this.promptTemplateVersions.put(version, promptTemplate);
        return this;
    }

    public void removePromptTemplate(long version) {
        this.promptTemplateVersions.remove(version);
    }

    public void updatePromptTemplate(long version, PromptTemplate promptTemplate) {
        this.promptTemplateVersions.put(version, promptTemplate);
    }
}

