/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.store.vectordb.integration.pinecone;

import ai.knowly.langtorch.processor.EmbeddingProcessor;
import ai.knowly.langtorch.schema.embeddings.EmbeddingInput;
import ai.knowly.langtorch.schema.embeddings.EmbeddingOutput;
import ai.knowly.langtorch.schema.io.DomainDocument;
import ai.knowly.langtorch.schema.io.Metadata;
import ai.knowly.langtorch.store.vectordb.integration.VectorStore;
import ai.knowly.langtorch.store.vectordb.integration.pinecone.schema.PineconeSimilaritySearchQuery;
import ai.knowly.langtorch.store.vectordb.integration.pinecone.schema.PineconeVectorStoreSpec;
import ai.knowly.langtorch.store.vectordb.integration.pinecone.schema.dto.Vector;
import ai.knowly.langtorch.store.vectordb.integration.pinecone.schema.dto.query.Match;
import ai.knowly.langtorch.store.vectordb.integration.pinecone.schema.dto.query.QueryRequest;
import ai.knowly.langtorch.store.vectordb.integration.pinecone.schema.dto.query.QueryResponse;
import ai.knowly.langtorch.store.vectordb.integration.pinecone.schema.dto.upsert.UpsertRequest;
import ai.knowly.langtorch.store.vectordb.integration.pinecone.schema.dto.upsert.UpsertResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.Pair;

public class PineconeVectorStore
implements VectorStore {
    private final EmbeddingProcessor embeddingProcessor;
    private final PineconeVectorStoreSpec pineconeVectorStoreSpec;

    @Inject
    public PineconeVectorStore(EmbeddingProcessor embeddingProcessor, PineconeVectorStoreSpec pineconeVectorStoreSpec) {
        this.embeddingProcessor = embeddingProcessor;
        this.pineconeVectorStoreSpec = pineconeVectorStoreSpec;
    }

    public UpsertResponse addDocuments(List<DomainDocument> documents) {
        return this.addVectors(documents.stream().map(this::createVector).collect(Collectors.toCollection(ArrayList::new)));
    }

    private UpsertResponse addVectors(List<Vector> vectors) {
        UpsertRequest.UpsertRequestBuilder upsertRequestBuilder = UpsertRequest.builder().setVectors(vectors);
        this.pineconeVectorStoreSpec.getNamespace().ifPresent(upsertRequestBuilder::setNamespace);
        return this.pineconeVectorStoreSpec.getPineconeService().upsert(upsertRequestBuilder.build());
    }

    private Vector createVector(DomainDocument document) {
        EmbeddingOutput embeddingOutput = (EmbeddingOutput)this.embeddingProcessor.run(EmbeddingInput.builder().setModel(this.pineconeVectorStoreSpec.getModel()).setInput(Collections.singletonList(document.getPageContent())).build());
        return Vector.builder().setId(document.getId().orElse(UUID.randomUUID().toString())).setMetadata(document.getMetadata().orElse(Metadata.getDefaultInstance()).getValue()).setValues(embeddingOutput.getValue().get(0).getVector()).build();
    }

    public List<Pair<DomainDocument, Double>> similaritySearchVectorWithScore(PineconeSimilaritySearchQuery pineconeSimilaritySearchQuery) {
        QueryRequest.QueryRequestBuilder requestBuilder = QueryRequest.builder().setIncludeMetadata(true).setTopK(pineconeSimilaritySearchQuery.getK()).setVector(pineconeSimilaritySearchQuery.getQuery()).setFilter(pineconeSimilaritySearchQuery.getFilter());
        this.pineconeVectorStoreSpec.getNamespace().ifPresent(requestBuilder::setNamespace);
        QueryResponse response = this.pineconeVectorStoreSpec.getPineconeService().query(requestBuilder.build());
        ArrayList<Pair<DomainDocument, Double>> result = new ArrayList<Pair<DomainDocument, Double>>();
        if (response.getMatches() != null) {
            for (Match match : response.getMatches()) {
                Metadata metadata;
                if (!this.pineconeVectorStoreSpec.getTextKey().isPresent()) continue;
                Metadata metadata2 = metadata = match.getMetadata() == null ? Metadata.getDefaultInstance() : Metadata.builder().setValue(match.getMetadata()).build();
                if (match.getScore() == null) continue;
                result.add((Pair<DomainDocument, Double>)Pair.of((Object)DomainDocument.builder().setPageContent(metadata.getValue().get(this.pineconeVectorStoreSpec.getTextKey().get())).setMetadata(metadata).build(), (Object)match.getScore()));
            }
        }
        return result;
    }
}

