/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.hub;

import ai.knowly.langtorch.hub.module.token.OpenAITokenModule;
import ai.knowly.langtorch.hub.schema.OpenAIKeyConfig;
import ai.knowly.langtorch.llm.openai.modules.key.OpenAIServiceConfigWithExplicitAPIKeyModule;
import ai.knowly.langtorch.llm.openai.modules.key.OpenAIServiceConfigWithImplicitAPIKeyModule;
import ai.knowly.langtorch.processor.openai.chat.OpenAIChatProcessorConfig;
import ai.knowly.langtorch.store.memory.conversation.ConversationMemory;
import com.google.inject.AbstractModule;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public final class LangtorchHubModuleRegistry
extends AbstractModule {
    private final List<AbstractModule> modules = new ArrayList<AbstractModule>();

    public static LangtorchHubModuleRegistry create() {
        return new LangtorchHubModuleRegistry();
    }

    public List<AbstractModule> getModules() {
        return this.modules;
    }

    public void registerOpenAiModule(OpenAIKeyConfig config) {
        this.modules.add(new OpenAITokenModule());
        this.modules.add(this.getOpenAIModule(config));
        this.modules.add(new AbstractModule(){

            protected void configure() {
                this.bind(ConversationMemory.class).toInstance((Object)ConversationMemory.getDefaultInstance());
                this.bind(OpenAIChatProcessorConfig.class).toInstance((Object)OpenAIChatProcessorConfig.getDefaultInstance());
            }
        });
    }

    private AbstractModule getOpenAIModule(OpenAIKeyConfig openAIKeyConfig) {
        Optional<String> config = openAIKeyConfig.getOpenAiApiKey();
        if (openAIKeyConfig.isReadFromEnvFile()) {
            return new OpenAIServiceConfigWithImplicitAPIKeyModule();
        }
        if (config.isPresent()) {
            return new OpenAIServiceConfigWithExplicitAPIKeyModule(config.get());
        }
        throw new IllegalArgumentException("OpenAI API key is not present. Please provide the API key in the config.");
    }

    private LangtorchHubModuleRegistry() {
    }
}

