/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.hub.module.token;

import ai.knowly.langtorch.hub.module.token.TokenUsage;
import ai.knowly.langtorch.llm.openai.schema.dto.completion.CompletionResult;
import ai.knowly.langtorch.llm.openai.schema.dto.completion.chat.ChatCompletionResult;
import com.google.common.flogger.FluentLogger;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class OpenAITokenUsageInterceptor
implements MethodInterceptor {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private final Provider<TokenUsage> tokenUsage;

    @Inject
    public OpenAITokenUsageInterceptor(Provider<TokenUsage> tokenUsage) {
        this.tokenUsage = tokenUsage;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object result = invocation.proceed();
        if (result instanceof ListenableFuture) {
            final SettableFuture newFuture = SettableFuture.create();
            ListenableFuture originalFuture = (ListenableFuture)result;
            Futures.addCallback((ListenableFuture)originalFuture, (FutureCallback)new FutureCallback(){

                public void onSuccess(Object result) {
                    if (result instanceof ChatCompletionResult) {
                        ChatCompletionResult chatCompletionResult = (ChatCompletionResult)result;
                        ((TokenUsage)OpenAITokenUsageInterceptor.this.tokenUsage.get()).getPromptTokenUsage().getAndAdd(chatCompletionResult.getUsage().getPromptTokens());
                        ((TokenUsage)OpenAITokenUsageInterceptor.this.tokenUsage.get()).getCompletionTokenUsage().addAndGet(chatCompletionResult.getUsage().getCompletionTokens());
                    }
                    if (result instanceof CompletionResult) {
                        CompletionResult completionResult = (CompletionResult)result;
                        ((TokenUsage)OpenAITokenUsageInterceptor.this.tokenUsage.get()).getPromptTokenUsage().getAndAdd(completionResult.getUsage().getPromptTokens());
                        ((TokenUsage)OpenAITokenUsageInterceptor.this.tokenUsage.get()).getCompletionTokenUsage().addAndGet(completionResult.getUsage().getCompletionTokens());
                    }
                    newFuture.set(result);
                }

                public void onFailure(Throwable thrown) {
                    ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).withCause(thrown)).log("Failed to add callback in OpenAITokenUsageInterceptor");
                    newFuture.setException(thrown);
                }
            }, (Executor)Executors.newCachedThreadPool());
            return newFuture;
        }
        return result;
    }
}

