/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.llm.huggingface;

import ai.knowly.langtorch.hub.module.token.EnableOpenAITokenRecord;
import ai.knowly.langtorch.llm.huggingface.HuggingFaceApi;
import ai.knowly.langtorch.llm.huggingface.HuggingFaceAuthenticationInterceptor;
import ai.knowly.langtorch.llm.huggingface.exception.HuggingFaceExecutionException;
import ai.knowly.langtorch.llm.huggingface.exception.HuggingFaceHttpException;
import ai.knowly.langtorch.llm.huggingface.exception.HuggingFaceServiceInterruptedException;
import ai.knowly.langtorch.llm.huggingface.schema.config.HuggingFaceServiceConfig;
import ai.knowly.langtorch.llm.huggingface.schema.dto.CreateTextGenerationTaskRequest;
import ai.knowly.langtorch.llm.huggingface.schema.dto.CreateTextGenerationTaskResponse;
import ai.knowly.langtorch.utils.future.retry.FutureRetrier;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.google.common.flogger.FluentLogger;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.HttpException;
import retrofit2.Retrofit;
import retrofit2.adapter.guava.GuavaCallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class HuggingFaceService {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static final String BASE_URL = "https://api-inference.huggingface.co/models/";
    private final HuggingFaceApi api;
    private final FutureRetrier futureRetrier;
    private final ScheduledExecutorService scheduledExecutor;

    @Inject
    public HuggingFaceService(HuggingFaceServiceConfig huggingFaceServiceConfig) {
        ObjectMapper defaultObjectMapper = HuggingFaceService.defaultObjectMapper();
        OkHttpClient client = HuggingFaceService.buildClient(huggingFaceServiceConfig);
        Retrofit retrofit = HuggingFaceService.defaultRetrofit(huggingFaceServiceConfig.modelId(), client, defaultObjectMapper);
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
        this.futureRetrier = new FutureRetrier(this.scheduledExecutor, huggingFaceServiceConfig.backoffStrategy(), huggingFaceServiceConfig.retryConfig());
        this.api = (HuggingFaceApi)retrofit.create(HuggingFaceApi.class);
    }

    public static <T> T execute(ListenableFuture<T> apiCall) {
        try {
            return (T)apiCall.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            ((FluentLogger.Api)((FluentLogger.Api)logger.atSevere()).withCause((Throwable)e)).log("Thread was interrupted during API call.");
            throw new HuggingFaceServiceInterruptedException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof HttpException) {
                HttpException httpException = (HttpException)e.getCause();
                try {
                    String errorBody = httpException.response().errorBody().string();
                    ((FluentLogger.Api)logger.atSevere()).log("HTTP Error: %s", (Object)errorBody);
                    throw new HuggingFaceHttpException(errorBody);
                }
                catch (IOException ioException) {
                    ((FluentLogger.Api)((FluentLogger.Api)logger.atSevere()).withCause((Throwable)ioException)).log("Error while reading errorBody");
                }
            }
            throw new HuggingFaceExecutionException(e);
        }
    }

    public static ObjectMapper defaultObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        return mapper;
    }

    public static OkHttpClient buildClient(HuggingFaceServiceConfig huggingFaceServiceConfig) {
        return new OkHttpClient.Builder().addInterceptor((Interceptor)new HuggingFaceAuthenticationInterceptor(huggingFaceServiceConfig.apiToken())).connectionPool(new ConnectionPool(5, 1L, TimeUnit.SECONDS)).readTimeout(huggingFaceServiceConfig.timeoutDuration().toMillis(), TimeUnit.MILLISECONDS).build();
    }

    public static Retrofit defaultRetrofit(String modelId, OkHttpClient client, ObjectMapper mapper) {
        String url = BASE_URL + modelId + "/";
        return new Retrofit.Builder().baseUrl(url).client(client).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)mapper)).addCallAdapterFactory((CallAdapter.Factory)GuavaCallAdapterFactory.create()).build();
    }

    public List<CreateTextGenerationTaskResponse> createTextGenerationTask(CreateTextGenerationTaskRequest request) {
        return HuggingFaceService.execute(this.createChatCompletionAsync(request));
    }

    @EnableOpenAITokenRecord
    public ListenableFuture<List<CreateTextGenerationTaskResponse>> createChatCompletionAsync(CreateTextGenerationTaskRequest request) {
        return this.futureRetrier.runWithRetries(() -> this.api.createTextGenerationTask(request), result -> true);
    }
}

