/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.llm.minimax;

import ai.knowly.langtorch.llm.minimax.MiniMaxApi;
import ai.knowly.langtorch.llm.minimax.MiniMaxAuthenticationInterceptor;
import ai.knowly.langtorch.llm.minimax.schema.MiniMaxApiBusinessErrorException;
import ai.knowly.langtorch.llm.minimax.schema.MiniMaxApiExecutionException;
import ai.knowly.langtorch.llm.minimax.schema.MiniMaxApiServiceInterruptedException;
import ai.knowly.langtorch.llm.minimax.schema.config.MiniMaxServiceConfig;
import ai.knowly.langtorch.llm.minimax.schema.dto.BaseResp;
import ai.knowly.langtorch.llm.minimax.schema.dto.completion.ChatCompletionRequest;
import ai.knowly.langtorch.llm.minimax.schema.dto.completion.ChatCompletionResult;
import ai.knowly.langtorch.llm.minimax.schema.dto.embedding.EmbeddingRequest;
import ai.knowly.langtorch.llm.minimax.schema.dto.embedding.EmbeddingResult;
import ai.knowly.langtorch.utils.future.retry.FutureRetrier;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.google.common.flogger.FluentLogger;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.HttpException;
import retrofit2.Retrofit;
import retrofit2.adapter.guava.GuavaCallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class MiniMaxService {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static final String BASE_URL = "https://api.minimax.chat";
    private final MiniMaxApi api;
    private final FutureRetrier futureRetrier;
    private final ScheduledExecutorService scheduledExecutor;

    @Inject
    public MiniMaxService(MiniMaxServiceConfig miniMaxServiceConfig) {
        ObjectMapper defaultObjectMapper = MiniMaxService.defaultObjectMapper();
        OkHttpClient client = MiniMaxService.buildClient(miniMaxServiceConfig);
        Retrofit retrofit = MiniMaxService.defaultRetrofit(client, defaultObjectMapper);
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
        this.futureRetrier = new FutureRetrier(this.scheduledExecutor, miniMaxServiceConfig.backoffStrategy(), miniMaxServiceConfig.retryConfig());
        this.api = (MiniMaxApi)retrofit.create(MiniMaxApi.class);
    }

    public static Retrofit defaultRetrofit(OkHttpClient client, ObjectMapper mapper) {
        return new Retrofit.Builder().baseUrl(BASE_URL).client(client).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)mapper)).addCallAdapterFactory((CallAdapter.Factory)GuavaCallAdapterFactory.create()).build();
    }

    public static OkHttpClient buildClient(MiniMaxServiceConfig miniMaxServiceConfig) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().addInterceptor((Interceptor)new MiniMaxAuthenticationInterceptor(miniMaxServiceConfig.groupId(), miniMaxServiceConfig.apiKey())).connectionPool(new ConnectionPool(5, 1L, TimeUnit.SECONDS)).readTimeout(miniMaxServiceConfig.timeoutDuration().toMillis(), TimeUnit.MILLISECONDS);
        return builder.build();
    }

    public static ObjectMapper defaultObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        return mapper;
    }

    public ChatCompletionResult createChatCompletion(ChatCompletionRequest request) {
        ChatCompletionResult chatCompletionResult = (ChatCompletionResult)MiniMaxService.execute(this.futureRetrier.runWithRetries(() -> this.api.createChatCompletion(request), result -> true));
        this.checkResp(chatCompletionResult.getBaseResp());
        return chatCompletionResult;
    }

    public ListenableFuture<ChatCompletionResult> createChatCompletionAsync(ChatCompletionRequest request) {
        return this.futureRetrier.runWithRetries(() -> this.api.createChatCompletion(request), result -> true);
    }

    public EmbeddingResult createEmbeddings(EmbeddingRequest request) {
        EmbeddingResult embeddingResult = (EmbeddingResult)MiniMaxService.execute(this.futureRetrier.runWithRetries(() -> this.api.createEmbeddings(request), result -> true));
        this.checkResp(embeddingResult.getBaseResp());
        return embeddingResult;
    }

    public ListenableFuture<EmbeddingResult> createEmbeddingsAsync(EmbeddingRequest request) {
        return this.futureRetrier.runWithRetries(() -> this.api.createEmbeddings(request), result -> true);
    }

    public void checkResp(BaseResp baseResp) {
        if (baseResp.getStatusCode() != 0L) {
            throw new MiniMaxApiBusinessErrorException(baseResp.getStatusCode(), baseResp.getStatusMsg());
        }
    }

    public static <T> T execute(ListenableFuture<T> apiCall) {
        try {
            return (T)apiCall.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            ((FluentLogger.Api)((FluentLogger.Api)logger.atSevere()).withCause((Throwable)e)).log("Thread was interrupted during API call.");
            throw new MiniMaxApiServiceInterruptedException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof HttpException) {
                HttpException httpException = (HttpException)e.getCause();
                try {
                    String errorBody = httpException.response().errorBody().string();
                    ((FluentLogger.Api)logger.atSevere()).log("HTTP Error: %s", (Object)errorBody);
                }
                catch (IOException ioException) {
                    ((FluentLogger.Api)((FluentLogger.Api)logger.atSevere()).withCause((Throwable)ioException)).log("Error while reading errorBody");
                }
            }
            throw new MiniMaxApiExecutionException(e);
        }
    }
}

