/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.llm.openai.tokenization;

import ai.knowly.langtorch.llm.openai.tokenization.Encodings;
import ai.knowly.langtorch.llm.openai.util.OpenAIModel;
import ai.knowly.langtorch.schema.chat.ChatMessage;
import com.google.common.collect.ImmutableList;
import com.knuddels.jtokkit.api.Encoding;
import java.util.List;
import java.util.Objects;

public class OpenAITokenizer {
    private static final ImmutableList<OpenAIModel> GPT_3_MODELS = ImmutableList.of((Object)((Object)OpenAIModel.GPT_3_5_TURBO), (Object)((Object)OpenAIModel.GPT_3_5_TURBO_16K), (Object)((Object)OpenAIModel.GPT_3_5_TURBO_0613), (Object)((Object)OpenAIModel.GPT_3_5_TURBO_16K_0613));
    private static final ImmutableList<OpenAIModel> GPT_4_MODELS = ImmutableList.of((Object)((Object)OpenAIModel.GPT_4), (Object)((Object)OpenAIModel.GPT_4_0613), (Object)((Object)OpenAIModel.GPT_4_32K), (Object)((Object)OpenAIModel.GPT_4_32K_0613));

    public static List<Integer> encode(OpenAIModel model, String text) {
        return Objects.requireNonNull((Encoding)Encodings.ENCODING_BY_MODEL.get((Object)model)).encode(text);
    }

    public static String decode(OpenAIModel model, List<Integer> tokens) {
        return Objects.requireNonNull((Encoding)Encodings.ENCODING_BY_MODEL.get((Object)model)).decode(tokens);
    }

    public static long getTokenNumber(OpenAIModel model, String text) {
        return OpenAITokenizer.encode(model, text).size();
    }

    public static long getTokenNumber(OpenAIModel model, List<ChatMessage> messages) {
        int tokensPerMessage = 0;
        int tokensPerName = 0;
        if (GPT_3_MODELS.contains((Object)model)) {
            tokensPerMessage = 4;
            tokensPerName = -1;
        } else if (GPT_4_MODELS.contains((Object)model)) {
            tokensPerMessage = 3;
            tokensPerName = 1;
        } else {
            throw new UnsupportedOperationException("You model is not supported yet for token counting.");
        }
        int numberOfTokens = 0;
        for (ChatMessage message : messages) {
            numberOfTokens += tokensPerMessage;
            numberOfTokens += OpenAITokenizer.encode(model, message.getContent()).size();
            numberOfTokens += OpenAITokenizer.encode(model, message.getRole().name()).size();
            numberOfTokens += OpenAITokenizer.encode(model, message.getName()).size() + tokensPerName;
        }
        return numberOfTokens += 3;
    }

    private OpenAITokenizer() {
    }
}

