/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.processor.openai.text;

import ai.knowly.langtorch.llm.openai.schema.dto.completion.CompletionRequest;
import ai.knowly.langtorch.processor.openai.text.OpenAITextProcessorConfig;
import java.util.List;
import java.util.Map;

public final class OpenAITextProcessorRequestConverter {
    private OpenAITextProcessorRequestConverter() {
    }

    public static CompletionRequest convert(OpenAITextProcessorConfig openAITextProcessorConfig, String prompt) {
        CompletionRequest completionRequest = new CompletionRequest();
        completionRequest.setModel(openAITextProcessorConfig.getModel());
        completionRequest.setPrompt(prompt);
        openAITextProcessorConfig.getSuffix().ifPresent(completionRequest::setSuffix);
        openAITextProcessorConfig.getMaxTokens().ifPresent(completionRequest::setMaxTokens);
        openAITextProcessorConfig.getTemperature().ifPresent(completionRequest::setTemperature);
        openAITextProcessorConfig.getTopP().ifPresent(completionRequest::setTopP);
        openAITextProcessorConfig.getN().ifPresent(completionRequest::setN);
        openAITextProcessorConfig.getStream().ifPresent(completionRequest::setStream);
        openAITextProcessorConfig.getLogprobs().ifPresent(completionRequest::setLogprobs);
        openAITextProcessorConfig.getEcho().ifPresent(completionRequest::setEcho);
        if (!openAITextProcessorConfig.getStop().isEmpty()) {
            completionRequest.setStop((List<String>)openAITextProcessorConfig.getStop());
        }
        openAITextProcessorConfig.getPresencePenalty().ifPresent(completionRequest::setPresencePenalty);
        openAITextProcessorConfig.getFrequencyPenalty().ifPresent(completionRequest::setFrequencyPenalty);
        openAITextProcessorConfig.getBestOf().ifPresent(completionRequest::setBestOf);
        completionRequest.setLogitBias((Map<String, Integer>)openAITextProcessorConfig.getLogitBias());
        openAITextProcessorConfig.getUser().ifPresent(completionRequest::setUser);
        return completionRequest;
    }
}

