/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.store.vectordb.integration.pgvector;

import ai.knowly.langtorch.store.vectordb.integration.pgvector.PGVectorSQLException;
import com.google.common.flogger.FluentLogger;
import com.pgvector.PGvector;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.inject.Inject;

public class PGVectorService {
    private static final String CREATE_VECTOR_EXTENSION_QUERY = "CREATE EXTENSION IF NOT EXISTS vector";
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private final Connection connection;
    private final Statement defaultStatement;

    @Inject
    public PGVectorService(Connection connection) {
        this.connection = connection;
        try {
            PGvector.addVectorType((Connection)connection);
            this.defaultStatement = connection.createStatement();
            this.defaultStatement.executeUpdate(CREATE_VECTOR_EXTENSION_QUERY);
        }
        catch (SQLException e) {
            ((FluentLogger.Api)((FluentLogger.Api)logger.atSevere()).withCause((Throwable)e)).log("Error while initialising PGVectorService");
            throw new PGVectorSQLException(e);
        }
    }

    public int executeUpdate(String sql) throws SQLException {
        return this.defaultStatement.executeUpdate(sql);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.connection.prepareStatement(sql);
    }

    public ResultSet query(String sql) throws SQLException {
        return this.defaultStatement.executeQuery(sql);
    }
}

