/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.store.vectordb.integration.pgvector;

import lombok.NonNull;

public class SqlCommandProvider {
    @NonNull
    private final String databaseName;
    private final boolean overwrite;

    public String getCreateEmbeddingsTableQuery(int vectorDimensions) {
        if (vectorDimensions <= 0) {
            throw new IllegalArgumentException("vectorDimensions must be greater than 0, was " + vectorDimensions);
        }
        String query = "";
        if (this.overwrite) {
            query = query + "DROP TABLE IF EXISTS " + this.getEmbeddingsTableName() + " CASCADE; ";
        }
        query = query + "CREATE TABLE IF NOT EXISTS ";
        query = query + this.getEmbeddingsTableName() + " (id TEXT PRIMARY KEY, embedding vector(" + vectorDimensions + "))";
        return query;
    }

    public String getCreateMetadataTableQuery() {
        String query = "";
        if (this.overwrite) {
            query = query + "DROP TABLE IF EXISTS " + this.getMetadataTableName() + "; ";
        }
        query = query + "CREATE TABLE IF NOT EXISTS ";
        query = query + this.getMetadataTableName() + " (id TEXT PRIMARY KEY, key TEXT, value TEXT ,vector_id TEXT ,FOREIGN KEY (vector_id) REFERENCES " + this.getEmbeddingsTableName() + "(id))";
        return query;
    }

    public String getInsertEmbeddingsQuery(String parameters) {
        return "INSERT INTO " + this.getEmbeddingsTableName() + " (id, embedding) VALUES " + parameters;
    }

    public String getInsertMetadataQuery(String parameters) {
        return "INSERT INTO " + this.getMetadataTableName() + " (id, key, value, vector_id) VALUES " + parameters;
    }

    public String getSelectEmbeddingsQuery(String distanceStrategy, long limit) {
        return "SELECT " + this.getEmbeddingsTableName() + ".id, embedding, key, value FROM (SELECT " + this.getEmbeddingsTableName() + ".id, embedding FROM " + this.getEmbeddingsTableName() + " LIMIT " + limit + " ) AS " + this.getEmbeddingsTableName() + " LEFT JOIN " + this.getMetadataTableName() + " ON " + this.getEmbeddingsTableName() + ".id = " + this.getMetadataTableName() + ".vector_id ORDER BY embedding " + distanceStrategy + " ? ";
    }

    private String getEmbeddingsTableName() {
        return this.databaseName + "_embeddings";
    }

    private String getMetadataTableName() {
        return this.getEmbeddingsTableName() + "_metadata";
    }

    public SqlCommandProvider(@NonNull String databaseName, boolean overwrite) {
        if (databaseName == null) {
            throw new NullPointerException("databaseName is marked non-null but is null");
        }
        this.databaseName = databaseName;
        this.overwrite = overwrite;
    }
}

