/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.store.vectordb.integration.pgvector.schema;

import java.util.Optional;
import lombok.NonNull;

public class PGVectorStoreSpec {
    private final String model;
    @NonNull
    private final String databaseName;
    private final String textKey;
    private final int vectorDimensions;
    private final boolean overwriteExistingTables;

    public Optional<String> getTextKey() {
        return Optional.ofNullable(this.textKey);
    }

    private static String $default$model() {
        return "text-embedding-ada-002";
    }

    PGVectorStoreSpec(String model, @NonNull String databaseName, String textKey, int vectorDimensions, boolean overwriteExistingTables) {
        if (databaseName == null) {
            throw new NullPointerException("databaseName is marked non-null but is null");
        }
        this.model = model;
        this.databaseName = databaseName;
        this.textKey = textKey;
        this.vectorDimensions = vectorDimensions;
        this.overwriteExistingTables = overwriteExistingTables;
    }

    public static PGVectorStoreSpecBuilder builder() {
        return new PGVectorStoreSpecBuilder();
    }

    public PGVectorStoreSpecBuilder toBuilder() {
        return new PGVectorStoreSpecBuilder().setModel(this.model).setDatabaseName(this.databaseName).setTextKey(this.textKey).setVectorDimensions(this.vectorDimensions).setOverwriteExistingTables(this.overwriteExistingTables);
    }

    public String getModel() {
        return this.model;
    }

    @NonNull
    public String getDatabaseName() {
        return this.databaseName;
    }

    public int getVectorDimensions() {
        return this.vectorDimensions;
    }

    public boolean isOverwriteExistingTables() {
        return this.overwriteExistingTables;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PGVectorStoreSpec)) {
            return false;
        }
        PGVectorStoreSpec other = (PGVectorStoreSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getVectorDimensions() != other.getVectorDimensions()) {
            return false;
        }
        if (this.isOverwriteExistingTables() != other.isOverwriteExistingTables()) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$databaseName = this.getDatabaseName();
        String other$databaseName = other.getDatabaseName();
        if (this$databaseName == null ? other$databaseName != null : !this$databaseName.equals(other$databaseName)) {
            return false;
        }
        Optional<String> this$textKey = this.getTextKey();
        Optional<String> other$textKey = other.getTextKey();
        return !(this$textKey == null ? other$textKey != null : !((Object)this$textKey).equals(other$textKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PGVectorStoreSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getVectorDimensions();
        result = result * 59 + (this.isOverwriteExistingTables() ? 79 : 97);
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $databaseName = this.getDatabaseName();
        result = result * 59 + ($databaseName == null ? 43 : $databaseName.hashCode());
        Optional<String> $textKey = this.getTextKey();
        result = result * 59 + ($textKey == null ? 43 : ((Object)$textKey).hashCode());
        return result;
    }

    public String toString() {
        return "PGVectorStoreSpec(model=" + this.getModel() + ", databaseName=" + this.getDatabaseName() + ", textKey=" + this.getTextKey() + ", vectorDimensions=" + this.getVectorDimensions() + ", overwriteExistingTables=" + this.isOverwriteExistingTables() + ")";
    }

    public static class PGVectorStoreSpecBuilder {
        private boolean model$set;
        private String model$value;
        private String databaseName;
        private String textKey;
        private int vectorDimensions;
        private boolean overwriteExistingTables;

        PGVectorStoreSpecBuilder() {
        }

        public PGVectorStoreSpecBuilder setModel(String model) {
            this.model$value = model;
            this.model$set = true;
            return this;
        }

        public PGVectorStoreSpecBuilder setDatabaseName(@NonNull String databaseName) {
            if (databaseName == null) {
                throw new NullPointerException("databaseName is marked non-null but is null");
            }
            this.databaseName = databaseName;
            return this;
        }

        public PGVectorStoreSpecBuilder setTextKey(String textKey) {
            this.textKey = textKey;
            return this;
        }

        public PGVectorStoreSpecBuilder setVectorDimensions(int vectorDimensions) {
            this.vectorDimensions = vectorDimensions;
            return this;
        }

        public PGVectorStoreSpecBuilder setOverwriteExistingTables(boolean overwriteExistingTables) {
            this.overwriteExistingTables = overwriteExistingTables;
            return this;
        }

        public PGVectorStoreSpec build() {
            String model$value = this.model$value;
            if (!this.model$set) {
                model$value = PGVectorStoreSpec.$default$model();
            }
            return new PGVectorStoreSpec(model$value, this.databaseName, this.textKey, this.vectorDimensions, this.overwriteExistingTables);
        }

        public String toString() {
            return "PGVectorStoreSpec.PGVectorStoreSpecBuilder(model$value=" + this.model$value + ", databaseName=" + this.databaseName + ", textKey=" + this.textKey + ", vectorDimensions=" + this.vectorDimensions + ", overwriteExistingTables=" + this.overwriteExistingTables + ")";
        }
    }
}

