/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.utils.api.key;

import ai.knowly.langtorch.utils.Environment;
import ai.knowly.langtorch.utils.api.key.ApiKeyEnvUtils;
import ai.knowly.langtorch.utils.api.key.KeyType;
import com.google.common.flogger.FluentLogger;
import java.util.Optional;

public class CohereKeyUtil {
    private CohereKeyUtil() {
    }

    public static String getKey(Environment environment) {
        return CohereKeyUtil.getKey(Optional.empty(), environment);
    }

    public static String getKey(FluentLogger logger, Environment environment) {
        return CohereKeyUtil.getKey(Optional.ofNullable(logger), environment);
    }

    private static String getKey(Optional<FluentLogger> logger, Environment environment) {
        String endpointFromEnv = ApiKeyEnvUtils.getKeyFromEnv(KeyType.COHERE_API_KEY, environment);
        logger.ifPresent(l -> ApiKeyEnvUtils.logPartialApiKey(l, KeyType.COHERE_API_KEY.name(), endpointFromEnv));
        return endpointFromEnv;
    }
}

