/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.utils.api.key;

import ai.knowly.langtorch.utils.Environment;
import ai.knowly.langtorch.utils.api.key.ApiKeyEnvUtils;
import ai.knowly.langtorch.utils.api.key.KeyType;
import com.google.common.flogger.FluentLogger;
import java.util.Optional;

public class MiniMaxKeyUtil {
    private MiniMaxKeyUtil() {
    }

    public static String getGroupId(Environment environment) {
        return MiniMaxKeyUtil.getGroupId(Optional.empty(), environment);
    }

    public static String getGroupId(FluentLogger logger, Environment environment) {
        return MiniMaxKeyUtil.getGroupId(Optional.ofNullable(logger), environment);
    }

    private static String getGroupId(Optional<FluentLogger> logger, Environment environment) {
        String groupIdFromEnv = ApiKeyEnvUtils.getKeyFromEnv(KeyType.MINMAX_GROUP_ID, environment);
        logger.ifPresent(l -> ApiKeyEnvUtils.logPartialApiKey(l, KeyType.MINMAX_GROUP_ID.name(), groupIdFromEnv));
        return groupIdFromEnv;
    }

    public static String getKey(Environment environment) {
        return MiniMaxKeyUtil.getKey(Optional.empty(), environment);
    }

    public static String getKey(FluentLogger logger, Environment environment) {
        return MiniMaxKeyUtil.getKey(Optional.ofNullable(logger), environment);
    }

    private static String getKey(Optional<FluentLogger> logger, Environment environment) {
        String keyFromEnv = ApiKeyEnvUtils.getKeyFromEnv(KeyType.MINIMAX_API_KEY, environment);
        logger.ifPresent(l -> ApiKeyEnvUtils.logPartialApiKey(l, KeyType.MINIMAX_API_KEY.name(), keyFromEnv));
        return keyFromEnv;
    }
}

