package ai.knowly.langtorch.llm.openai.schema.dto.edit;

import ai.knowly.langtorch.llm.openai.schema.dto.Usage;
import java.util.List;
import lombok.Data;

/**
 * A list of edits generated by OpenAI
 *
 * <p>https://beta.openai.com/docs/api-reference/edits/create
 */
@Data
public class EditResult {

  /** The type of object returned, should be "edit" */
  private String object;

  /** The creation time in epoch milliseconds. */
  private long created;

  /** A list of generated edits. */
  private List<EditChoice> choices;

  /** The API usage for this request */
  private Usage usage;
}
