package ai.knowly.langtorch.store.vectordb.integration.pgvector.schema.distance;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;

@AllArgsConstructor(access = AccessLevel.PACKAGE)
public class CosineDistanceStrategy implements DistanceStrategy {

  @Override
  public String getSyntax() {
    return "<=>";
  }

  @Override
  public double calculateDistance(double[] vector1, double[] vector2) {
    if (vector1.length != vector2.length) {
      throw new IllegalArgumentException("Vector dimensions do not match.");
    }
    double dotProduct = 0.0;
    double normA = 0.0;
    double normB = 0.0;
    for (int i = 0; i < vector1.length; i++) {
      dotProduct += vector1[i] * vector2[i];
      normA += Math.pow(vector1[i], 2);
      normB += Math.pow(vector2[i], 2);
    }
    return dotProduct / (Math.sqrt(normA) * Math.sqrt(normB));
  }
}
