/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtoch.capability.unit;

import ai.knowly.langtoch.capability.unit.AutoValue_LLMCapabilityUnit;
import ai.knowly.langtoch.capability.unit.CapabilityUnit;
import ai.knowly.langtoch.llm.base.BaseModel;
import ai.knowly.langtoch.parser.input.StringInputParser;
import ai.knowly.langtoch.parser.output.StringOutputParser;
import com.google.auto.value.AutoValue;
import java.util.Optional;

@AutoValue
public abstract class LLMCapabilityUnit<T, R>
extends CapabilityUnit<T, R> {
    public static <T, R> Builder<T, R> builder() {
        return new AutoValue_LLMCapabilityUnit.Builder();
    }

    public abstract Optional<BaseModel> model();

    public abstract Optional<StringOutputParser<R>> outputParser();

    public abstract Optional<StringInputParser<T>> inputParser();

    @Override
    public R run(T input) {
        String parsedInput = this.inputParser().isPresent() ? (String)this.inputParser().get().parse(input) : (String)input;
        String output = this.model().get().run(parsedInput);
        return (R)(this.outputParser().isPresent() ? this.outputParser().get().parse(output) : output);
    }

    @AutoValue.Builder
    public static abstract class Builder<T, R> {
        public abstract Builder<T, R> setModel(BaseModel var1);

        public abstract Builder<T, R> setOutputParser(StringOutputParser<R> var1);

        public abstract Builder<T, R> setInputParser(StringInputParser<T> var1);

        abstract Optional<StringOutputParser<R>> outputParser();

        abstract Optional<StringInputParser<T>> inputParser();

        abstract Optional<BaseModel> model();

        abstract LLMCapabilityUnit<T, R> autoBuild();

        public LLMCapabilityUnit<T, R> build() {
            if (this.model().isEmpty()) {
                throw new IllegalStateException("Model must be set.");
            }
            return this.autoBuild();
        }
    }
}

