/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtoch.llm.providers.openai;

import ai.knowly.langtoch.llm.base.BaseModel;
import ai.knowly.langtoch.llm.providers.openai.Utils;
import com.google.common.flogger.FluentLogger;
import com.theokanning.openai.completion.CompletionChoice;
import com.theokanning.openai.completion.CompletionRequest;
import com.theokanning.openai.completion.CompletionResult;
import com.theokanning.openai.service.OpenAiService;
import io.github.cdimascio.dotenv.Dotenv;
import java.util.Objects;
import javax.inject.Inject;

public class OpenAI
extends BaseModel {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private final String DEFAULT_MODEL = "text-davinci-003";
    private final int DEFAULT_MAX_TOKENS = 2048;
    private final OpenAiService openAiService;
    private final CompletionRequest.CompletionRequestBuilder completionRequest = CompletionRequest.builder().maxTokens(Integer.valueOf(2048)).model("text-davinci-003");

    @Inject
    OpenAI(OpenAiService openAiService) {
        this.openAiService = openAiService;
    }

    public OpenAI(String apiKey) {
        Utils.logPartialApiKey(logger, apiKey);
        this.openAiService = new OpenAiService(apiKey);
    }

    public OpenAI() {
        this.openAiService = new OpenAiService(this.getApiKeyFromEnv());
    }

    public OpenAI setMaxTokens(int maxTokens) {
        this.completionRequest.maxTokens(Integer.valueOf(maxTokens));
        return this;
    }

    public OpenAI setModel(String model) {
        this.completionRequest.model(model);
        return this;
    }

    public OpenAI setTemperature(double temperature) {
        this.completionRequest.temperature(Double.valueOf(temperature));
        return this;
    }

    @Override
    public String run(String prompt) {
        CompletionResult completion = this.openAiService.createCompletion(this.completionRequest.prompt(prompt).build());
        return ((CompletionChoice)completion.getChoices().get(0)).getText();
    }

    private String getApiKeyFromEnv() {
        Dotenv dotenv = Dotenv.load();
        String openaiApiKey = Objects.requireNonNull(dotenv.get("OPENAI_API_KEY"));
        Utils.logPartialApiKey(logger, openaiApiKey);
        return openaiApiKey;
    }
}

