/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtoch.prompt;

import ai.knowly.langtoch.prompt.AutoValue_PromptTemplate;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@AutoValue
public abstract class PromptTemplate {
    public static final String VARIABLE_TEMPLATE_PATTERN = "\\{\\{\\$([a-zA-Z0-9_]+)\\}\\}";

    public static Builder builder() {
        return new AutoValue_PromptTemplate.Builder();
    }

    public static ImmutableList<String> extractVariableNames(String template) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Pattern compiledPattern = Pattern.compile(VARIABLE_TEMPLATE_PATTERN);
        Matcher matcher = compiledPattern.matcher(template);
        while (matcher.find()) {
            builder.add((Object)matcher.group(1));
        }
        return builder.build();
    }

    public abstract Optional<String> template();

    public abstract ImmutableMap<String, String> variables();

    private void validate() {
        if (this.template().isEmpty()) {
            throw new IllegalArgumentException("Template is not present.");
        }
        ImmutableList<String> variableNamesFromTemplate = PromptTemplate.extractVariableNames(this.template().get());
        ImmutableMap<String, String> variablesInMap = this.variables();
        if (variableNamesFromTemplate.size() != variablesInMap.size()) {
            throw new IllegalArgumentException("Number of variables in the template must match the number of variables in the map.");
        }
        variableNamesFromTemplate.forEach(variableName -> {
            if (!variablesInMap.containsKey(variableName)) {
                throw new IllegalArgumentException(String.format("Variable %s is not present in the variables map.", variableName));
            }
        });
    }

    public String format() {
        this.validate();
        if (this.variables().isEmpty()) {
            return this.template().get();
        }
        Pattern compiledPattern = Pattern.compile(VARIABLE_TEMPLATE_PATTERN);
        Matcher matcher = compiledPattern.matcher(this.template().get());
        StringBuilder outputBuffer = new StringBuilder();
        while (matcher.find()) {
            String variableName = matcher.group(1);
            String replacement = (String)this.variables().getOrDefault((Object)variableName, (Object)"");
            matcher.appendReplacement(outputBuffer, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(outputBuffer);
        return outputBuffer.toString();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setTemplate(String var1);

        abstract ImmutableMap.Builder<String, String> variablesBuilder();

        public Builder addVariableValuePair(String variableName, String value) {
            this.variablesBuilder().put((Object)variableName, (Object)value);
            return this;
        }

        public Builder addAllVariableValuePairs(Map<String, String> variables) {
            this.variablesBuilder().putAll(variables);
            return this;
        }

        public abstract PromptTemplate build();
    }
}

