/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.capability.modality.text;

import ai.knowly.langtorch.capability.modality.text.TextLLMCapability;
import ai.knowly.langtorch.llm.processor.Processor;
import ai.knowly.langtorch.memory.Memory;
import ai.knowly.langtorch.parser.Parser;
import ai.knowly.langtorch.schema.io.SingleText;
import ai.knowly.langtorch.schema.memory.MemoryKey;
import ai.knowly.langtorch.schema.memory.MemoryValue;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Optional;

public class TextCompletionTextLLMCapability<I, O>
implements TextLLMCapability<I, SingleText, SingleText, O> {
    private final Processor<SingleText, SingleText> processor;
    private Optional<Parser<I, SingleText>> inputParser;
    private Optional<Parser<SingleText, O>> outputParser;
    private Optional<Memory<MemoryKey, MemoryValue>> memory;

    public TextCompletionTextLLMCapability(Processor<SingleText, SingleText> processor) {
        this.processor = processor;
        this.inputParser = Optional.empty();
        this.outputParser = Optional.empty();
        this.memory = Optional.empty();
    }

    public static <I, O> TextCompletionTextLLMCapability<I, O> of(Processor<SingleText, SingleText> processor) {
        return new TextCompletionTextLLMCapability<I, O>(processor);
    }

    public TextCompletionTextLLMCapability<I, O> withInputParser(Parser<I, SingleText> inputParser) {
        this.inputParser = Optional.of(inputParser);
        return this;
    }

    public TextCompletionTextLLMCapability<I, O> withOutputParser(Parser<SingleText, O> outputParser) {
        this.outputParser = Optional.of(outputParser);
        return this;
    }

    public TextCompletionTextLLMCapability<I, O> withMemory(Memory<MemoryKey, MemoryValue> memory) {
        this.memory = Optional.of(memory);
        return this;
    }

    @Override
    public SingleText preProcess(I inputData) {
        if (inputData instanceof SingleText) {
            return (SingleText)inputData;
        }
        if (this.inputParser.isPresent()) {
            return this.inputParser.get().parse(inputData);
        }
        throw new IllegalArgumentException("Input data is not a SingleText and no input parser is present.");
    }

    @Override
    public Optional<Memory<MemoryKey, MemoryValue>> getMemory() {
        return this.memory;
    }

    @Override
    public O postProcess(SingleText outputData) {
        if (this.outputParser.isPresent()) {
            return this.outputParser.get().parse(outputData);
        }
        throw new IllegalArgumentException("Output data type is not SingleText and no output parser is present.");
    }

    @Override
    public O run(I inputData) {
        return this.postProcess(this.processor.run((SingleText)this.preProcess((Object)inputData)));
    }

    @Override
    public ListenableFuture<O> runAsync(I inputData) {
        return FluentFuture.from((ListenableFuture)Futures.immediateFuture(inputData)).transform(this::run, MoreExecutors.directExecutor());
    }
}

