/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.llm;

import com.google.common.flogger.FluentLogger;
import io.github.cdimascio.dotenv.Dotenv;
import java.util.Optional;

public class Utils {
    public static void logPartialApiKey(FluentLogger logger, String provider, String apiKey) {
        ((FluentLogger.Api)logger.atInfo()).log("Using %s API key: ***************" + apiKey.substring(apiKey.length() - 6), (Object)provider);
    }

    public static String getOpenAIApiKeyFromEnv() {
        return Utils.getOpenAIApiKeyFromEnv(Optional.empty());
    }

    public static String getOpenAIApiKeyFromEnv(Optional<FluentLogger> logger) {
        Dotenv dotenv = Dotenv.configure().ignoreIfMissing().load();
        String openaiApiKey = dotenv.get("OPENAI_API_KEY");
        logger.ifPresent(l -> Utils.logPartialApiKey(l, "OpenAI", openaiApiKey));
        return openaiApiKey;
    }

    public static String getCohereAIApiKeyFromEnv() {
        return Utils.getCohereAIApiKeyFromEnv(Optional.empty());
    }

    public static String getCohereAIApiKeyFromEnv(Optional<FluentLogger> logger) {
        Dotenv dotenv = Dotenv.configure().ignoreIfMissing().load();
        String openaiApiKey = dotenv.get("COHERE_API_KEY");
        logger.ifPresent(l -> Utils.logPartialApiKey(l, "CohereAI", openaiApiKey));
        return openaiApiKey;
    }
}

