/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.llm.integration.cohere;

import ai.knowly.langtorch.llm.integration.cohere.CohereApi;
import ai.knowly.langtorch.llm.integration.cohere.CohereAuthenticationInterceptor;
import ai.knowly.langtorch.llm.integration.cohere.schema.CohereGenerateRequest;
import ai.knowly.langtorch.llm.integration.cohere.schema.CohereGenerateResponse;
import ai.knowly.langtorch.llm.integration.cohere.schema.CohereHttpException;
import ai.knowly.langtorch.llm.integration.cohere.serialization.CohereGenerateRequestAdapter;
import com.google.common.flogger.FluentLogger;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.HttpException;
import retrofit2.Retrofit;
import retrofit2.adapter.guava.GuavaCallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

public class CohereAPIService {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private static final String BASE_URL = "https://api.cohere.ai/";
    private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(10L);
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(CohereGenerateRequest.class, (Object)new CohereGenerateRequestAdapter()).create();
    private final CohereApi api;

    public CohereAPIService(String token) {
        this(token, DEFAULT_TIMEOUT);
    }

    public CohereAPIService(String token, Duration timeout) {
        this(CohereAPIService.buildApi(token, timeout));
    }

    public CohereAPIService(CohereApi api) {
        this.api = api;
    }

    public static <T> T execute(ListenableFuture<T> apiCall) {
        try {
            return (T)apiCall.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof HttpException) {
                HttpException httpException = (HttpException)e.getCause();
                try {
                    String errorBody = httpException.response().errorBody().string();
                    ((FluentLogger.Api)logger.atSevere()).log("HTTP Error: %s", (Object)errorBody);
                    throw new CohereHttpException(errorBody, httpException.code(), (Exception)httpException);
                }
                catch (IOException ioException) {
                    ((FluentLogger.Api)((FluentLogger.Api)logger.atSevere()).withCause((Throwable)ioException)).log("Error while reading errorBody");
                }
            }
            throw new RuntimeException(e);
        }
    }

    public static CohereApi buildApi(String token, Duration timeout) {
        Objects.requireNonNull(token, "OpenAI token required");
        OkHttpClient client = CohereAPIService.defaultClient(token, timeout);
        Retrofit retrofit = CohereAPIService.defaultRetrofit(client, gson);
        CohereApi cohereApi = (CohereApi)retrofit.create(CohereApi.class);
        return cohereApi;
    }

    public static OkHttpClient defaultClient(String token, Duration timeout) {
        return new OkHttpClient.Builder().addInterceptor((Interceptor)new CohereAuthenticationInterceptor(token)).connectionPool(new ConnectionPool(5, 1L, TimeUnit.SECONDS)).readTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS).build();
    }

    public static Retrofit defaultRetrofit(OkHttpClient client, Gson gson) {
        return new Retrofit.Builder().baseUrl(BASE_URL).client(client).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).addCallAdapterFactory((CallAdapter.Factory)GuavaCallAdapterFactory.create()).build();
    }

    public CohereGenerateResponse generate(CohereGenerateRequest request) {
        return CohereAPIService.execute(this.api.generate(request));
    }

    public ListenableFuture<CohereGenerateResponse> generateAsync(CohereGenerateRequest request) {
        return this.api.generate(request);
    }
}

