/*
 * Decompiled with CFR 0.152.
 */
package ai.knowly.langtorch.llm.integration.cohere.schema;

import ai.knowly.langtorch.llm.integration.cohere.schema.CohereGenerateRequest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

final class AutoValue_CohereGenerateRequest
extends CohereGenerateRequest {
    private final String prompt;
    private final String model;
    private final Integer numGenerations;
    private final Integer maxTokens;
    private final String preset;
    private final Double temperature;
    private final Integer k;
    private final Double p;
    private final Double frequencyPenalty;
    private final Double presencePenalty;
    private final ImmutableList<String> endSequences;
    private final ImmutableList<String> stopSequences;
    private final String returnLikelihoods;
    private final ImmutableMap<String, Float> logitBias;
    private final String truncate;

    private AutoValue_CohereGenerateRequest(String prompt, String model, Integer numGenerations, Integer maxTokens, String preset, Double temperature, Integer k, Double p, Double frequencyPenalty, Double presencePenalty, ImmutableList<String> endSequences, ImmutableList<String> stopSequences, String returnLikelihoods, ImmutableMap<String, Float> logitBias, String truncate) {
        this.prompt = prompt;
        this.model = model;
        this.numGenerations = numGenerations;
        this.maxTokens = maxTokens;
        this.preset = preset;
        this.temperature = temperature;
        this.k = k;
        this.p = p;
        this.frequencyPenalty = frequencyPenalty;
        this.presencePenalty = presencePenalty;
        this.endSequences = endSequences;
        this.stopSequences = stopSequences;
        this.returnLikelihoods = returnLikelihoods;
        this.logitBias = logitBias;
        this.truncate = truncate;
    }

    @Override
    public String prompt() {
        return this.prompt;
    }

    @Override
    public String model() {
        return this.model;
    }

    @Override
    public Integer numGenerations() {
        return this.numGenerations;
    }

    @Override
    public Integer maxTokens() {
        return this.maxTokens;
    }

    @Override
    public String preset() {
        return this.preset;
    }

    @Override
    public Double temperature() {
        return this.temperature;
    }

    @Override
    public Integer k() {
        return this.k;
    }

    @Override
    public Double p() {
        return this.p;
    }

    @Override
    public Double frequencyPenalty() {
        return this.frequencyPenalty;
    }

    @Override
    public Double presencePenalty() {
        return this.presencePenalty;
    }

    @Override
    public ImmutableList<String> endSequences() {
        return this.endSequences;
    }

    @Override
    public ImmutableList<String> stopSequences() {
        return this.stopSequences;
    }

    @Override
    public String returnLikelihoods() {
        return this.returnLikelihoods;
    }

    @Override
    public ImmutableMap<String, Float> logitBias() {
        return this.logitBias;
    }

    @Override
    public String truncate() {
        return this.truncate;
    }

    public String toString() {
        return "CohereGenerateRequest{prompt=" + this.prompt + ", model=" + this.model + ", numGenerations=" + this.numGenerations + ", maxTokens=" + this.maxTokens + ", preset=" + this.preset + ", temperature=" + this.temperature + ", k=" + this.k + ", p=" + this.p + ", frequencyPenalty=" + this.frequencyPenalty + ", presencePenalty=" + this.presencePenalty + ", endSequences=" + this.endSequences + ", stopSequences=" + this.stopSequences + ", returnLikelihoods=" + this.returnLikelihoods + ", logitBias=" + this.logitBias + ", truncate=" + this.truncate + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CohereGenerateRequest) {
            CohereGenerateRequest that = (CohereGenerateRequest)o;
            return this.prompt.equals(that.prompt()) && this.model.equals(that.model()) && this.numGenerations.equals(that.numGenerations()) && this.maxTokens.equals(that.maxTokens()) && this.preset.equals(that.preset()) && this.temperature.equals(that.temperature()) && this.k.equals(that.k()) && this.p.equals(that.p()) && this.frequencyPenalty.equals(that.frequencyPenalty()) && this.presencePenalty.equals(that.presencePenalty()) && this.endSequences.equals(that.endSequences()) && this.stopSequences.equals(that.stopSequences()) && this.returnLikelihoods.equals(that.returnLikelihoods()) && this.logitBias.equals(that.logitBias()) && this.truncate.equals(that.truncate());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.prompt.hashCode();
        h$ *= 1000003;
        h$ ^= this.model.hashCode();
        h$ *= 1000003;
        h$ ^= this.numGenerations.hashCode();
        h$ *= 1000003;
        h$ ^= this.maxTokens.hashCode();
        h$ *= 1000003;
        h$ ^= this.preset.hashCode();
        h$ *= 1000003;
        h$ ^= this.temperature.hashCode();
        h$ *= 1000003;
        h$ ^= this.k.hashCode();
        h$ *= 1000003;
        h$ ^= this.p.hashCode();
        h$ *= 1000003;
        h$ ^= this.frequencyPenalty.hashCode();
        h$ *= 1000003;
        h$ ^= this.presencePenalty.hashCode();
        h$ *= 1000003;
        h$ ^= this.endSequences.hashCode();
        h$ *= 1000003;
        h$ ^= this.stopSequences.hashCode();
        h$ *= 1000003;
        h$ ^= this.returnLikelihoods.hashCode();
        h$ *= 1000003;
        h$ ^= this.logitBias.hashCode();
        h$ *= 1000003;
        return h$ ^= this.truncate.hashCode();
    }

    static final class Builder
    extends CohereGenerateRequest.Builder {
        private String prompt;
        private String model;
        private Integer numGenerations;
        private Integer maxTokens;
        private String preset;
        private Double temperature;
        private Integer k;
        private Double p;
        private Double frequencyPenalty;
        private Double presencePenalty;
        private ImmutableList<String> endSequences;
        private ImmutableList<String> stopSequences;
        private String returnLikelihoods;
        private ImmutableMap<String, Float> logitBias;
        private String truncate;

        Builder() {
        }

        @Override
        public CohereGenerateRequest.Builder prompt(String prompt) {
            if (prompt == null) {
                throw new NullPointerException("Null prompt");
            }
            this.prompt = prompt;
            return this;
        }

        @Override
        public CohereGenerateRequest.Builder model(String model) {
            if (model == null) {
                throw new NullPointerException("Null model");
            }
            this.model = model;
            return this;
        }

        @Override
        public CohereGenerateRequest.Builder numGenerations(Integer numGenerations) {
            if (numGenerations == null) {
                throw new NullPointerException("Null numGenerations");
            }
            this.numGenerations = numGenerations;
            return this;
        }

        @Override
        public CohereGenerateRequest.Builder maxTokens(Integer maxTokens) {
            if (maxTokens == null) {
                throw new NullPointerException("Null maxTokens");
            }
            this.maxTokens = maxTokens;
            return this;
        }

        @Override
        public CohereGenerateRequest.Builder preset(String preset) {
            if (preset == null) {
                throw new NullPointerException("Null preset");
            }
            this.preset = preset;
            return this;
        }

        @Override
        public CohereGenerateRequest.Builder temperature(Double temperature) {
            if (temperature == null) {
                throw new NullPointerException("Null temperature");
            }
            this.temperature = temperature;
            return this;
        }

        @Override
        public CohereGenerateRequest.Builder k(Integer k) {
            if (k == null) {
                throw new NullPointerException("Null k");
            }
            this.k = k;
            return this;
        }

        @Override
        public CohereGenerateRequest.Builder p(Double p) {
            if (p == null) {
                throw new NullPointerException("Null p");
            }
            this.p = p;
            return this;
        }

        @Override
        public CohereGenerateRequest.Builder frequencyPenalty(Double frequencyPenalty) {
            if (frequencyPenalty == null) {
                throw new NullPointerException("Null frequencyPenalty");
            }
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        @Override
        public CohereGenerateRequest.Builder presencePenalty(Double presencePenalty) {
            if (presencePenalty == null) {
                throw new NullPointerException("Null presencePenalty");
            }
            this.presencePenalty = presencePenalty;
            return this;
        }

        @Override
        public CohereGenerateRequest.Builder endSequences(List<String> endSequences) {
            this.endSequences = ImmutableList.copyOf(endSequences);
            return this;
        }

        @Override
        public CohereGenerateRequest.Builder stopSequences(List<String> stopSequences) {
            this.stopSequences = ImmutableList.copyOf(stopSequences);
            return this;
        }

        @Override
        public CohereGenerateRequest.Builder returnLikelihoods(String returnLikelihoods) {
            if (returnLikelihoods == null) {
                throw new NullPointerException("Null returnLikelihoods");
            }
            this.returnLikelihoods = returnLikelihoods;
            return this;
        }

        @Override
        public CohereGenerateRequest.Builder logitBias(Map<String, Float> logitBias) {
            this.logitBias = ImmutableMap.copyOf(logitBias);
            return this;
        }

        @Override
        public CohereGenerateRequest.Builder truncate(String truncate) {
            if (truncate == null) {
                throw new NullPointerException("Null truncate");
            }
            this.truncate = truncate;
            return this;
        }

        @Override
        public CohereGenerateRequest build() {
            if (this.prompt == null || this.model == null || this.numGenerations == null || this.maxTokens == null || this.preset == null || this.temperature == null || this.k == null || this.p == null || this.frequencyPenalty == null || this.presencePenalty == null || this.endSequences == null || this.stopSequences == null || this.returnLikelihoods == null || this.logitBias == null || this.truncate == null) {
                StringBuilder missing = new StringBuilder();
                if (this.prompt == null) {
                    missing.append(" prompt");
                }
                if (this.model == null) {
                    missing.append(" model");
                }
                if (this.numGenerations == null) {
                    missing.append(" numGenerations");
                }
                if (this.maxTokens == null) {
                    missing.append(" maxTokens");
                }
                if (this.preset == null) {
                    missing.append(" preset");
                }
                if (this.temperature == null) {
                    missing.append(" temperature");
                }
                if (this.k == null) {
                    missing.append(" k");
                }
                if (this.p == null) {
                    missing.append(" p");
                }
                if (this.frequencyPenalty == null) {
                    missing.append(" frequencyPenalty");
                }
                if (this.presencePenalty == null) {
                    missing.append(" presencePenalty");
                }
                if (this.endSequences == null) {
                    missing.append(" endSequences");
                }
                if (this.stopSequences == null) {
                    missing.append(" stopSequences");
                }
                if (this.returnLikelihoods == null) {
                    missing.append(" returnLikelihoods");
                }
                if (this.logitBias == null) {
                    missing.append(" logitBias");
                }
                if (this.truncate == null) {
                    missing.append(" truncate");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_CohereGenerateRequest(this.prompt, this.model, this.numGenerations, this.maxTokens, this.preset, this.temperature, this.k, this.p, this.frequencyPenalty, this.presencePenalty, this.endSequences, this.stopSequences, this.returnLikelihoods, this.logitBias, this.truncate);
        }
    }
}

